# -*- coding: UTF-8 -*-
import commonFunction
import traceback

LANG = py_java_env.get("lang")
LOGGER = PY_LOGGER

def execute(cli):
    '''
        巡检工具增加针对硬盘域同一层级中硬盘容量不一致导致大容量的硬盘容量被截断或者性能下降风险的检查： 
        背景：新扩容的1.8T SSD盘，实际可用容量只有900G。扩容后的可用容量小于规划的可用容量，不满足客户需求。
        步骤1 以admin用户登录设备
       步骤2 执行命令：show upgrade package，查询系统版本。
       步骤3 执行命令：show disk general,统计所有盘的类型和容量。
    '''
    
    allCliRet = ""
    errMsg = ""
    
    #涉及问题版本
    bugVersionList = ["V300R005C00.*", "V300R001C10.*", "V300R001C20.*", "V300R002C00.*", \
                      "V300R002C10.*", "V300R003C00.*", "V300R003C10.*", "V300R003C20$", \
                      "V300R003C20SPC100$", "V200R001C00.*", "V200R002C00.*","V200R002C20.*", "V200R002C30.*"]

    try:
        #查询设备型版本
        checkRet = checkVersion(cli, bugVersionList, LOGGER)
        allCliRet += checkRet[1]
        #检查过程异常退出
        if not checkRet[0]:
            errInfo = {"zh":u"\n查询结果异常",
                    "en":"\nQuery result is abnormal",}
            PY_LOGGER.info("Inspect[disk_domain_expansion] inspect not pass. (system abnormal!)")
            return (False, allCliRet, errInfo.get(LANG))
                
        #非问题版本
        if checkRet[2]:
            LOGGER.info("The product version is %s." % (checkRet[3]))
            return (True, allCliRet, errMsg)
                
        #获取所有盘的信息
        cmd = "show disk general"
        cliRet = cli.execCmd(cmd)
        allCliRet += cliRet
        
        #不存在硬盘的场景
        if commonFunction.queryResultWithNoRecord(cliRet):
            return ("WARNING", allCliRet, errMsg)
 
        #检查同一种类型的硬盘存在空闲盘，且空闲盘与成员盘的容量相差大于等于50GB
        differNum = 50
        checkRet, errInfo = checkFreeAndMembDiskDifferCap(cliRet, differNum, LOGGER, LANG)
        if not checkRet:
            errMsg += errInfo
            return (False, allCliRet, errMsg) 
        
        #容量差不超过50G，报建议优化
        errInfo = {"zh":u"\n若涉及扩容，待扩的硬盘型号和容量和已存在的硬盘不一致时，建议将待扩的硬盘新建硬盘域。",
                   "en":"\nIf disk expansion is involved in the disk domain, the type and capacity of disks to be expanded are different from those of existing disks, you are advised to create a disk domain for the disks to be expanded."}
        errMsg += errInfo.get(LANG)       
        return ("WARNING", allCliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Inspect[disk_domain_expansion] inspect exception: " + traceback.format_exc())
        errInfo = {"zh":u"\n获取信息失败",
                   "en":"\nThere is an error in getting information",}
        return (False, allCliRet, errInfo.get(LANG))
    
def checkVersion(cli, bugVersionList, logger):
    """
    @summary: 检查设备版本是否为问题版本
    @param bugVersionList: 问题版本，版本为正则表达式， "V300R005C00.*"表示V300R005C00所以版本           
    @return: 
        isSucc：True/False，方法是否正常结束
        allCliRet：所有CLID回显
        errMsg：方法异常结束时的原因
        isPass：True/False，检查是否通过（设备版本不是问题版本时检查通过）
        productVersion：设备版本
    """
    isSucc = True
    allCliRet = ""
    errMsg = ""
    
    isPass = True
    productVersion = ""
      
    #获取产品软件版本
    flag, cliRet, productVersion = commonFunction.getProductFullVersion(cli, logger)
    allCliRet += cliRet
    if flag != True:
        isSucc = False
        isPass = False
        return (isSucc, allCliRet, isPass, productVersion)
            
    if commonFunction.isBugProductVersion(productVersion, bugVersionList):
        #问题版本匹配
        isSucc = True
        isPass = False
        return (isSucc, allCliRet, isPass, productVersion)
    else:
        return (isSucc, allCliRet, isPass, productVersion)

def checkFreeAndMembDiskDifferCap(cliRet, number, LOGGER, LANG):
    '''
    @summary: 判断同一种类型的空闲盘与成员盘的容量相差值是否大于等于number
    @param number: 空闲盘与成员盘的容量相差值
    @return: True/False(True:否 False:是), errMsg (错误信息)
    '''
    errMsg = ""
    checkFlag = True
    
    getFlag, errInfo, freeDiskInfoDict, membDiskInfoDict = getFreeAndMemDiskInfo(cliRet, LANG, LOGGER)            
    #获取信息失败
    if not getFlag:
        return False, errInfo
 
    #任何一种盘不存在，则不存在问题                 
    if not freeDiskInfoDict or not membDiskInfoDict:
        return True, errMsg
    
    for freeDiskId, freeTypeCapList in freeDiskInfoDict.items():
        freeDiskType = freeTypeCapList[0]
 
        for membDiskId, membTypeCapList in membDiskInfoDict.items():
            membDiskType = membTypeCapList[0]
            #类型不一样，不需要比较处理
            if freeDiskType != membDiskType:
                continue
            
            #获取自由盘和成员盘的容量差值
            freeDiskCapacity = freeTypeCapList[1]
            freeChangeRet = commonFunction.changUnit2GB(freeDiskCapacity)
            membDiskCapacity = membTypeCapList[1]
            membChangeRet = commonFunction.changUnit2GB(membDiskCapacity)                                               
            differNum = abs(freeChangeRet[1] - membChangeRet[1])
            
            #类型相同的盘需要比较容量差
            if differNum >=  number:
                checkFlag = False
                errInfo = {"zh":u"\n空闲盘（ID：%s）容量和成员盘（ID：%s）的容量相差%.3fGB。",
                           "en":"\nThe difference between the capacity of free disk (ID: %s) and that of member disk (ID: %s) is %.3f GB.",}
                errMsg += errInfo.get(LANG) % (freeDiskId, membDiskId, differNum)
   
    #相差大于等于50GB时给出处理建议            
    if not checkFlag:
        errInfo = {"zh":u"\n若涉及扩容，请将系统中空闲盘新建硬盘域，扩容硬盘域存在大容量硬盘利用率不高的风险。",
                   "en":"\nIf disk expansion is involved in the disk domain,create a disk domain for free disks in the system. The disk domain may contain large-capacity disks with low usage.",}
        errMsg += errInfo.get(LANG)

    return checkFlag, errMsg
                 
def getFreeAndMemDiskInfo(cliRet, LANG, LOGGER):
    '''
    @summary: 通过Cli回显获取成员盘和自由盘信息，返回字典
    '''
    errMsg = ""
    freeDiskInfoDict = {} 
    membDiskInfoDict = {}            
    diskInfoDictList = commonFunction.getHorizontalCliRet(cliRet)    
    
    #无法解析出硬盘信息
    if not diskInfoDictList:
        errInfo = {"zh":u"无法获取硬盘信息",
                   "en":"Cannot get information about disk"}
        return(False,errInfo.get(LANG), freeDiskInfoDict, membDiskInfoDict) 
    
    for diskInfoDict in diskInfoDictList:
        diskRole = diskInfoDict.get("Role", "")
        diskId = diskInfoDict.get("ID", "")  
        diskType = diskInfoDict.get("Type", "")    
        diskCapacity = diskInfoDict.get("Capacity", "")
        if diskRole == "Free Disk":
            freeDiskInfoDict.setdefault(diskId,[diskType, diskCapacity])
        elif diskRole == "Member Disk":
            membDiskInfoDict.setdefault(diskId,[diskType, diskCapacity])
    
    return (True, errMsg, freeDiskInfoDict, membDiskInfoDict)

    
              
                
        

    

    
