﻿#coding: UTF-8

import traceback
import os
import codecs
import shutil

list_cli_cmd = ["show system general",
                "show upgrade package"]

def collectCliCmd(devObj, fileBaseDir):
    """
    # 函数名称: collectCliCmd
    # 功能说明: 获取CLI命令信息
    # 其 他   :  无
    """

    logger = devObj.get("logger")
    try:
        #收集Cli命令
        ssh = devObj.get("ssh")
        cliCmdFile = os.path.join(fileBaseDir, "clicmd.txt")
        cliRet = ""
        for cmd in list_cli_cmd:
            cliRet += ssh.execCmd(cmd) + "\n"
        
        #将收集到的命令回文写入文件
        localFile = codecs.open(cliCmdFile, "a", "utf-8")
        try:
            localFile.write(cliRet)
        except:
            logger.error("Failed to write file:" + str(traceback.format_exc()))
            return False
        finally:
            localFile.close()
        return True
    except:
        logger.error("Failed to collect commands:" + str(traceback.format_exc()))
        return False
