#coding: UTF-8

import time
import traceback
import re
from time import sleep
import cliCmdManager
from constant import CLI_CMD
from constant import TOOLKIT_SEND_CMD_TIME_OUT
from commonFunction import getCtrlCmdMode
from constant import SSH_CLI_MODEL_TYPE

def changeCli2Developer(ssh, devPasswd, logger):
    '''
            函数名称: changeCli2Developer
            功能说明: 从CLI模式进入developer模式（需要确定使用之前为CLI模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    '''

    ret = cliCmdManager.execCmd(ssh, CLI_CMD.SWITCH_TO_DEVELOPER, logger)
    if not ret[0]:
        return False
    
    temp = ret[1]
    #判断是否已经developer模式
    if re.search("Password", temp, re.IGNORECASE):
        temp = ssh.execCmdNoLog(devPasswd)
        if re.search("developer", temp, re.IGNORECASE):
            return True
    
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False

def changeCli2DeveloperWithCliRet(ssh, devPasswd, logger):
    '''
            函数名称: changeCli2Developer
            功能说明: 从CLI模式进入developer模式（需要确定使用之前为CLI模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    '''

    ret = cliCmdManager.execCmd(ssh, CLI_CMD.SWITCH_TO_DEVELOPER, logger)
    if not ret[0]:
        return ret
    
    temp = ""
    #判断是否已经developer模式
    if re.search("Password", temp, re.IGNORECASE):
        temp = ssh.execCmdNoLog(devPasswd)
        if re.search("developer", temp, re.IGNORECASE):
            return True, ret[1] + "\n" + temp
    
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False, ret[1] + "\n" + temp

def changeCli2DeveloperWithErrMsg(ssh, py_java_env):
    '''
            函数名称: changeCli2DeveloperWithErrMsg
            功能说明: 从CLI模式进入developer模式（需要确定使用之前为CLI模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False, ErrMsg
    '''
    errMsg = ""
    lang = py_java_env.get("lang")
    devPasswd = py_java_env.get("devPwd").get("developer")
    if not devPasswd:
        if "zh" == lang:
            errMsg = u"\n获取调试密码为空，请确定是否已配置调试密码。"
        else:
            errMsg = "\nThe debug password is blank. Please confirm that the debug password is set."
        return False, errMsg
    
    cliRet = ssh.execCmd(CLI_CMD.SWITCH_TO_DEVELOPER)
    #判断是否已经developer模式
    for i in range(3):#密码错误 时需要重试三次
        if re.search("Password", cliRet, re.IGNORECASE):
            temp = ssh.execCmdNoLog(devPasswd)
            if re.search("developer", temp, re.IGNORECASE):
                return True, errMsg
    
    if "zh" == lang:
        errMsg = u"\n切换到developer模式失败，可能的原因是：当前用户不支持developer模式或调试密码输入错误。请按照如下建议处理：\
        \n（1）如果当前用户级别不是超级管理员或者管理员，请使用超级管理员或者管理员用户登录后重新执行巡检；\
        \n（2）如果当前用户级别是超级管理员或者管理员，请检查调试密码是否正确输入，输入正确的调试密码后重新执行巡检。"
    else:
        errMsg = u"\nFailed to switch to the developer mode. The reason of failure may be: Current user cannot switch to developer mode or the debug password entered is incorrect.\
        \n(1) If the current user level is not Super_admin or Admin, log in as Super_admin or Admin and perform inspection again. \
        \n(2) If the current user level is Super_admin or Admin, check whether the debug password is correct. Enter the correct debug password and perform inspection again."
    
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False,errMsg

def changeCli2Diagnose(ssh, devPasswd, logger):
    '''
            函数名称: changeCli2Diagnose
            功能说明: 从CLI模式进入diagnose模式（需要确定使用之前为CLI模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    '''
        
    if not changeCli2Developer(ssh, devPasswd, logger):
        return False
    
    devRet = ssh.execCmdWithTimout("debug", 10)
    if re.search('diagnose>', devRet, re.IGNORECASE):
        return True
   
    #进入diagnose模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False


def changeCli2DiagnoseWithCliRet(ssh, devPasswd, logger):
    '''
            函数名称: changeCli2Diagnose
            功能说明: 从CLI模式进入diagnose模式（需要确定使用之前为CLI模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    '''
    flag, cliRet = changeCli2DeveloperWithCliRet(ssh, devPasswd, logger)   
    if not flag:
        return flag, cliRet
    
    devRet = ssh.execCmdWithTimout("debug", 10)
    if re.search('diagnose>', devRet, re.IGNORECASE):
        return True, cliRet + "\n" + devRet
   
    #进入diagnose模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False, cliRet + "\n" + devRet 


def changeAnyModel2CliWithLog(ssh, logger):
    '''
            函数名称: changeAnyModel2CliWithLog
            功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    '''
    counter = 0
    
    try:
        while True:
            temp = ssh.execCmdWithTimout("show system general", 180)
            
            #非developer模式下，cli回文正确，则认为回到了cli
            if (re.search("System Name", temp, re.IGNORECASE) 
                and not re.search("developer:", temp, re.IGNORECASE)):
                    break
                
            #最小系统下执行exitSPC200及其之前的版本断开连接；SPC300及其之后的版本退回到developer模式。
            if re.search("minisystem", temp, re.IGNORECASE):
                temp1 = ssh.execCmd("exit")
                if re.search("Are you sure", temp1, re.IGNORECASE):
                    try:
                        ssh.execCmd("y")
                    except:#SPC200及之前的版本可能断开连接或者网络异常。
                        logger.error('Exit from minisystem exception, the SSH connection is disconnected, reconnect now! ')
                        ssh.reConnect()
            elif re.search("-bash", temp, re.IGNORECASE):#os_only模式下直接退出
                ssh.execCmdWithTimout("sh /ISM/cli/start.sh", 60)
            else:#其他情况下，直接exit
                temp1 = ssh.execCmd("exit")
                if re.search("Are you sure", temp1, re.IGNORECASE):
                    ssh.execCmd("n")
                    break
                
            #单控的命令模式最多4层
            counter += 1
            if counter >= 5:
                break
    except:
        logger.error('Exit to CLI mode failed!')
    else:
        logger.info('No exception caught when exiting to CLI mode')
    finally:
        model = getCtrlCmdMode(ssh, logger)
        logger.info("Change any mode to CLI mode result:" + unicode(model))
        
        return model

        

def changeAnyModel2Cli(ssh):
    '''
            函数名称: changeAnyModel2Cli
            功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    '''
    counter = 0
    
    while True:
        temp = ssh.execCmdWithTimout("show system general", 180)
        
        #非developer模式下，cli回文正确，则认为回到了cli
        if re.search("System Name", temp, re.IGNORECASE) \
            and not re.search("developer:", temp, re.IGNORECASE):
                break
            
        #最小系统下要用exit会直接断开连接（也可能退出到admin模式，待确认）
        if re.search("minisystem", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                try:
                    ssh.execCmd("y")
                except:
                    ssh.reConnect()
        #os_only模式下直接退出
        elif re.search("-bash", temp, re.IGNORECASE):
            ssh.execCmdWithTimout("sh /ISM/cli/start.sh", 60)
            
        #其他情况下，直接exit
        else:
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                ssh.execCmd("n")
                break
        
        #单控的命令模式最多4层
        counter += 1
        if counter >= 5:
            break
        
def changeDeveloper2Minisystem(ssh, py_java_env):
    '''
            函数名称: changeDeveloper2Minisystem
            功能说明: 从developer模式进入minisystem模式（需要确定使用之前为developer模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False 
    ''' 
    javaEnv = py_java_env 
    userName = javaEnv.get("devInfo").getLoginUser().getUserName()
    if "admin" == userName:
        temp = ssh.execCmdWithTimout("minisystem", 5)#进入minisystem
        if re.search("minisystem>", temp, re.IGNORECASE):
            return True
        
        if re.search("Are you sure", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("y")
            if re.search("minisystem>", temp1, re.IGNORECASE):
                return True
            
        return False
    else:
        return False
    
    
def changeCliModel2Minisystem(ssh, py_java_env, devPasswd, logger):
    '''
            函数名称: changeCliModel2Minisystem
            功能说明: 从CLI模式切换到minisystem模式
            输入参数: ssh, devPasswd, logger
            输出参数: 无
            返 回 值: True or False    
    '''
        
    if not changeCli2Developer(ssh, devPasswd, logger):
        logger.error('Switch cli to developer mode failed!')
        changeAnyModel2Cli(ssh)
        return False
        
    if not changeDeveloper2Minisystem(ssh, py_java_env):
        logger.error('Switch developer to minisystem mode failed!')
        changeAnyModel2Cli(ssh)
        return False
    
    logger.info('Switch cli to minisystem mode successfully!')
    return True

def exitFromPeerMinisystem(ssh):
    '''
            函数名称: exitFromPeerMinisystem
            功能说明: 从对端cli模式切换到本端minisystem模式
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False    
    '''
    count = 0
    while True:    
        temp = ssh.execCmd("exit")
        if re.search("Are you sure to exit", temp, re.IGNORECASE):
            temp = ssh.execCmdWithTimout('y', 30)
        if re.search('closed', temp, re.IGNORECASE):
            return True
        count += 1
        if count > 4:
            break

    return False 

def heartbeatToPeer(ssh, usrPwd, logger):
    '''
            函数名称: heartbeatToPeer
            功能说明: 从本端minisystem模式心跳到对端，此方法须在minisystem模式下调用
            输入参数: ssh,usrPwd
            输出参数: 无
            返 回 值: True or False    
    '''
    #******密码快过期导致心跳失败 begin！
    try:
        temp = ssh.execCmd("sshtoremote")

        if (re.search('Are you sure you want to continue connecting (yes/no)?', temp, re.IGNORECASE)):
            temp = ssh.execCmd("yes")
            
        if re.search("password:", temp, re.IGNORECASE):
            temp1 = ssh.execCmdNoLogTimout(usrPwd, 60)
            logger.info("[temp1] CLI echo text:" + unicode(temp1))
            
            if TOOLKIT_SEND_CMD_TIME_OUT == temp1:
                logger.error("[heartbeatToPeer] execute cmd timeout.")
                changeAnyModel2CliWithLog(ssh, logger)
                return False
            
            if (re.search("You have accessed the system operated", temp1, re.IGNORECASE)
                and temp1.endswith('admin:/>')):
                return True
            
        logger.error("[heartbeatToPeer] heart to peer failed.")
        changeAnyModel2CliWithLog(ssh, logger)
        return False
    except:
        logger.error("[heartbeatToPeer] catch trace back:" + unicode(traceback.print_exc()))
        changeAnyModel2CliWithLog(ssh, logger)
        return False
    
    #******密码快过期导致心跳失败 end！
    
   
