# -*- coding: UTF-8 -*-
import traceback
import os
import cliCmd
import time
from com.huawei.oss.cn.common.anonymize import FileAnonymizeUtil

def checkConfData(data):
    if data != None and \
        "get" in dir(data) and \
        "Expansion" == data.get("mainScene") and \
        "perInspector" == data.get("toolScene"):
        return True
    return False

def showMsg(data, lang):
    if checkConfData(data):
        if lang == "zh":
            return u"备份系统配置数据失败，请联系技术支持工程师"
        return "Failed to back up system configuration data. Please contact technical support engineers"
    return ""

def collectFile(devObj, localFileDir, collectItemList):
    #触发设备收集
    ssh = devObj.get("ssh")
    for collectItem in collectItemList:
        cmd = "show file export_path file_type=%s" % collectItem
        cliRet = ssh.execCmdNoLogTimout(cmd, 2*60)
        
        #下载文件
        remoteFile = cliRet.splitlines()[1].split(":")[1].strip()
        sftp = devObj.get("sftp")
        sftp.getFile(remoteFile, localFileDir, None)
        
        if "running_data" == collectItem:
            #对运行数据文件进行脱敏
            FileAnonymizeUtil.anonymizeWithEncoding(localFileDir, "utf-8")
            
        #删除设备上文件
        deleteFile(ssh, collectItem)
        
def execute(devObj):
    '''
    @summary: 收集设备上config.txt文件
    '''
    try:
        msg = ""
        dbConfig = "configuration_data"
        data = py_java_env.get("sceneData")
        #巡检场景收集项：运行数据
        collectItemList = ["running_data"]
        #扩容场景收集项，运行数据、配置数据
        PY_LOGGER.info("checkConfData : %s" % str(checkConfData(data)))
        if checkConfData(data):
            collectItemList.append(dbConfig)
        
        #增加收集config文件重试机制
        x = 4
        for i in range(1, x):
            try:
                PY_LOGGER.info("start the collect %s time" % i)
                PY_LOGGER.info("executing post inspect.")
                #为每套设备创建文件存放文件夹
                tmpDataDir = devObj.get("tmpDataDir")
                devIp = py_java_env.get("devInfo").getIp()
                #IPV6替换:为.否则创建文件夹失败
                devIp = str(devIp).replace(":", ".")                               
                devSN = py_java_env.get("devInfo").getDeviceSerialNumber()
                localFileDir = tmpDataDir + os.path.sep + "data" + os.path.sep + "config" + os.path.sep + devIp + "_" + devSN
                if not os.path.exists(localFileDir):
                    os.makedirs(localFileDir)
                        
                #触发设备收集
                collectFile(devObj, localFileDir, collectItemList)
                
                break
            except:
                PY_LOGGER.error("start the collect failed at %s time" % i)
                PY_LOGGER.error("Failed to collect cliCmd:" + str(traceback.format_exc()))
                msg = showMsg(data, py_java_env.get("lang"))
                time.sleep(5)
            
        
        #收集clicmd文件(忽略异常)
        try:
            cliCmdFileDir = os.path.join(tmpDataDir, "data", "Other", devIp + "_" + devSN)
            #创建文件夹
            if not os.path.exists(cliCmdFileDir):
                os.makedirs(cliCmdFileDir)
            devObj["logger"] = PY_LOGGER
            cliCmd.collectCliCmd(devObj, cliCmdFileDir)
        except:
            PY_LOGGER.error("Failed to collect cliCmd:" + str(traceback.format_exc()))
        
        PY_LOGGER.info("getting file %s success" % collectItemList)
        if msg:
            return ("ERROR", dict(flag=False, des=msg))
        
        return ("", dict(flag=True, des=""))
    except:
        PY_LOGGER.error("Failed to collect running file, because %s" % str(traceback.format_exc()))
        #后台收集，忽略失败
        return ("", dict(flag=True, des=""))
    
def deleteFile(ssh, collectItem):
    '''
    #删除阵列端数据
    '''
    try:
        cmd4delete = "delete file filetype=%s" % collectItem
        ssh.execCmd(cmd4delete)
    except:
        PY_LOGGER.error("deleteFile failed because cli execute failed")
