# -*- coding: UTF-8 -*-
import traceback
import re
G_ITEM_NUM_CONTROLLER = 1
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show system general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show controller general")
        PY_LOGGER.info("\nSequence[1] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        i = 0;j=0
        engineList = []
        for field in list:
            field = field.replace(" ","")
            
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[1] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[1]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("Controller:"):
                ctrlId = field.replace("Controller:","")
                #从控制器ID中获取控制器所在的引擎ID，并存放到列表engineList中
                engineId = ctrlId[0]
                engineList.append(engineId)
                continue
                        
            if field.startswith("HealthStatus"):
                if field.replace("HealthStatus:","") != "Normal":
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n控制器["+ctrlId+u"]健康状态检查异常"
                    else:
                        errMsg += "\nThe health status of Controller ["+ctrlId+"] is abnormal"
                i = i + 1
                continue
                
            if field.startswith("RunningStatus"):
                if field.replace("RunningStatus:","") != "Online":
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n控制器["+ctrlId+u"]运行状态检查异常"
                    else:
                        errMsg += "\nThe running status of Controller ["+ctrlId+"] is abnormal"
                j = j + 1
                continue
        
        if 0==i or 0==j:
            flag = False
            if "zh" == lang:
                errMsg = u"\n系统状态可能不正常，没有查询到任何控制器信息"
            else:
                errMsg = "\nSystem status may be abnormal, query no controller information"
        elif i%2 == 1 or j%2 == 1:
            flag = False
            if "zh" == lang:
                errMsg = u"\n可能存在离线的控制器"
            else:
                errMsg = "\nThe controller of the system may be offline"
        else:
            PY_LOGGER.info(u"all engine id:" + str(engineList))
            for engine in engineList:
                count = engineList.count(engine)
                #如果某个引擎出现的次数为奇数，则说明该引擎下的控制器数量不符合规范
                if count % 2 != 0:
                    flag = False
                    if "zh" == lang:
                        errMsg = u"\n可能存在离线的控制器"
                    else:
                        errMsg = "\nThe controller of the system may be offline"
                    PY_LOGGER.info(u"engine "+str(engine)+" has "+str(count)+" controllers")
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[1] catch except of check controller status.")
        PY_LOGGER.error("Sequence[1] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[1] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[1] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
            
        return (flag, cliRet, errMsg)
