# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showiscsiber")
    Return             : the checkitem is pass;cli source info
    """
    cliRet = ""
    lang = py_java_env.get("lang")
    try:
        flag = True
    	errMsg = ""
        cliRet = cli.execCmd("show port fibre_module|filterColumn include columnList=PortID,Health\sStatus,Model")
        PY_LOGGER.info("\nSequence[10] execute command result:\n" + cliRet)
        list = cliRet.splitlines()
        i = 0
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[10] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[10]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            i = i + 1
            if i >= 5:
                list2 = field.split()
                if -1 != field.find(":/>") or field.startswith("developer:/>"):
                    PY_LOGGER.info("Sequence[10] field is:"+field)
                    continue
                portId = list2[0]
                if list2[1] != "Normal":
                    flag = False
                    if "zh" == lang:
                        errMsg = errMsg + u"\n端口("+portId+u"状态异常("+list2[1]+u")"
                    else:
                        errMsg = errMsg + "\nThe status of port("+portId+") is abnormal("+list2[1]+")"
                        
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[10] catch except of check fibre module.")
        PY_LOGGER.error("Sequence[10] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[10] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[10] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
