# -*- coding: UTF-8 -*-
import traceback
import re
MAX_RETRYS = 5

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showfcber")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        cliRet = cli.execCmd("show controller general")
        PY_LOGGER.info("\nSequence[11] execute command result:\n" + cliRet)
        errMsg = ""
        list = cliRet.splitlines()
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[11] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[11]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            field = field.replace(" ","")
            if field.startswith("Controller:"):
                list2 = field.split(":")
                controller = str(list2[1])
    
            if field.startswith("AllTemperatures(Celsius)"):
                list2 = field.split(":")
                PY_LOGGER.info("list2[1] is: "+list2[1])
                #Get temperatures of four points: CPU, in, out1, out2
                list3 = str(list2[1]).split(",")
                if len(list3) < 2:
                    continue
                strTmprCpu = str(list3[0])
                strTmprIn = str(list3[1])
                if strTmprCpu.isdigit():
                    tempCPU = int(strTmprCpu)
                    if(tempCPU > 85):
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\n控制器[" + controller + u"] CPU温度大于85摄氏度"
                        else:
                            errMsg += "\nThe CPU temperature of controller[" + controller + u"] is greater than 85 celsius"

                if strTmprIn.isdigit():
                    tempIN = int(strTmprIn)
                    if(tempIN >= 52):
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\n控制器[" + controller + u"] 进风口温度大于等于52摄氏度"
                        else:
                            errMsg += "\nThe entrance temperature of controller[ "+ controller + u"] is greater than or equal to 52 celsius"
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[11] catch except of check controller temperature.")
        PY_LOGGER.error("Sequence[11] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[11] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[11] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
