# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsasber")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = cli.execCmd("show enclosure")
        PY_LOGGER.info("\nSequence[12] execute command result:\n" + cliRet)
        
        i = 0
        list = cliRet.splitlines()
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[12] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[12]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            if field.find("Enclosure") == -1 and field.find("Engine") == -1 :
                continue
            list2 = field.split()
            strTemperature = list2[len(list2)-1]
            if strTemperature.isdigit():
                temperature = int(strTemperature)
                if temperature >= 52:
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n框[" + list2[0] + u"]温度达到或超过52摄氏度"
                    else:
                        errMsg += "\nThe temperature of enclosure[" + list2[0] + "] reaches or exceeds 52 celsius"
                
        return (flag, cliRet, errMsg)
    except Exception, exception:
        PY_LOGGER.error("Sequence[12] catch except of check enclosure temperature.")
        PY_LOGGER.error("Sequence[12] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[12] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[12] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
