# -*- coding: UTF-8 -*-
import traceback
import re
import time
SLEEP_TIMES = 30
NEED_RETRY = False

# **************************************************************************** #
# 函数名称: checkFcPorts
# 功能说明: 判断FC端口是否巡检通过，由于是第一个涉及show port general命令的，因此不先
#           尝试通过接口从py_java_env中获取现成的showPortGeneral执行结果
# 输入参数: cli
# 输出参数: True or False
# **************************************************************************** # 
def checkFcPorts(cli):
    
    try:
        flag = True
        chkfc_start = False
        find_flag = False
        global NEED_RETRY
        lang = py_java_env.get("lang")
        errMsg = ""

        #Optimize check rate
        cliRet = "default"
        cliRet = py_java_env.get("showPortGeneral")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[13] execute command: \"show port general\".")
            cliRet = cli.execCmd("show port general")
            py_java_env.put("showPortGeneral", cliRet)
        PY_LOGGER.info("\nSequence[13] execute command result:\n" + cliRet)
        
        #用于判断“Error”是否在各个端口外
        isErrorOutOfPort = True
        
        list = cliRet.splitlines()
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[13] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            if field.find("FC port") != -1:
                chkfc_start = True
                isErrorOutOfPort = False
            if field.find("SAS port") != -1 or field.find("COM port") != -1 or field.find("ETH port") != -1 \
                or field.find("FCoE port") != -1 or field.find("PCIE port") != -1:
                chkfc_start = False
                isErrorOutOfPort = False
            if chkfc_start == True:
                
                #其它出现“Error:”字眼的信息视为不通过
                if re.search("Error:", field, re.IGNORECASE):
                    flag = False
                    PY_LOGGER.info("There is an error in Sequence[13]!")
                    if "zh" == lang:
                        errMsg = u"\n获取信息出错。"
                    else:
                        errMsg = "\nThere is an error in getting information."
                    return (flag, cliRet, errMsg)
                
                if field.find("Host Port") == -1:
                    continue
                list2 = field.split()
                #FC Health Status 不为Normal
                if list2[1] != "Normal":
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\nFC端口（" + list2[0] + u"）健康状态检查异常。"
                    else:
                        errMsg += "\nThe FC port (" + list2[0] + ") health status is abnormal."
                    continue
                
                #如果时速为--有可能是刚刚重启后造成的。
                if re.search("Link Up", field, re.IGNORECASE):
                    
                    if -1 != list2[6].find("--") and flag:
                        flag = False
                        NEED_RETRY = True
                        
                    #FC Health Status 为Normal，Running Status为Link Up,并且不为1000、2000、4000、8000    
                    if list2[6] not in ["1000", "2000", "4000", "8000"]:
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\nFC端口（" + list2[0] + u"）速率异常。"
                        else:
                            errMsg += "\nThe speed of FC port (" + list2[0] + ") is abnormal."
            
        #如果“Error”出现在命令的6个端口外，比如命令超时，就不会打印那6个端口信息
        if True == isErrorOutOfPort:
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", cliRet, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[13]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
                        
        return (flag, cliRet, errMsg)
                                  
    except Exception, exception:
        PY_LOGGER.error("Sequence[13] catch except of check FC port.")
        PY_LOGGER.error("Sequence[13] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[13] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[13] catch except of trace back:" + str(traceback.print_exc()))
        NEED_RETRY = False 
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
    
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showfibremodule")
    Return             : the checkitem is pass;cli source info
    """
    checkRet = checkFcPorts(cli)
    if NEED_RETRY:
        time.sleep(SLEEP_TIMES)
        checkRet = checkFcPorts(cli)

    return checkRet
