# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showexpmodule")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show enclosure")
        PY_LOGGER.info("\nSequence[2] execute command result:\n" + cliRet)

        list = cliRet.splitlines()
        i = 0
        for field in list:
            
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[2] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[2]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            list2 = field.split()
            i += 1
            if i >= 5 and len(list2) > 1:
                frameId = list2[0]
                # 处理标准：Health Status为Normal且Running Status为Online表示正常，其它情况均属于不正常状态
                if -1==field.find("Normal") or -1==field.find("Online"):
                    flag = False
                    PY_LOGGER.info("\nSequence[2] inspect not pass.")
                    if "zh" == lang:
                        errMsg = u"\n框("+frameId+u")状态异常"
                    else:
                        errMsg = "\nThe status of enclosure(" + frameId + ") is abnormal"
                    return (flag, cliRet, errMsg)
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[2] catch except of check enclosure status.")
        PY_LOGGER.error("Sequence[2] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[2] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[2] catch except of trace back:" + str(traceback.print_exc()))
        falg = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
