# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showrmtlink")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show controller general")
        PY_LOGGER.info("\nSequence[20] execute command result:\n" + cliRet)
        ctrlId = ""
        list = cliRet.splitlines()
         
        for field in list:
            field = field.replace(" ", "") 
            
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[20] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg) 
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[20]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("Controller:"):
                ctrlId = field.replace("Controller:","")
                continue
            
            if field.startswith("CPUUsage"):
                usage = field.split(":")[1]
                PY_LOGGER.info("CPU Usage is: " + usage)
                if int(usage) > 80:
                    flag = False
                    PY_LOGGER.info("CPU Usage is: " + usage)
                    if "zh" == lang:
                        errMsg += u"控制器[" + ctrlId + u"]CPU使用率超过80%。"
                    else:
                        errMsg += "\nController[" + ctrlId + "] CPU Usage exceeded 80%."  
        return (flag, cliRet, errMsg)
                
    except Exception, exception:
        PY_LOGGER.error("Sequence[20] catch except of check host port error.")
        PY_LOGGER.error("Sequence[20] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[20] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[20] catch except of trace back:" + str(traceback.print_exc()))
        return (flag, cliRet, errMsg)
