# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showrespool")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        chkfc_start = False
        find_flag = False
        lang = py_java_env.get("lang")
        errMsg = ""
        list3 = []
        list4 = []
        #Optimize check rate
        cliRet = "default"
        cliRet = py_java_env.get("showPortGeneral")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[22] execute command: \"show port general\".")
            cliRet = cli.execCmd("show port general")
            py_java_env.put("showPortGeneral", cliRet)
        PY_LOGGER.info("\nSequence[22] execute command result:\n" + cliRet)
        
        #用于判断“Error”是否在各个端口外
        isErrorOutOfPort = True
        
        list = cliRet.splitlines()
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[22] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            
            if field.find("PCIE port") != -1:
                chkfc_start = True
                isErrorOutOfPort = False
            if field.find("FC port") != -1 or field.find("COM port") != -1 or field.find("ETH port") != -1 \
                or field.find("SAS port") != -1 or field.find("FCoE port") != -1:
                chkfc_start = False
                isErrorOutOfPort = False
            if chkfc_start == True:
                #其它出现“Error:”字眼的信息视为不通过
                if re.search("Error:", field, re.IGNORECASE):
                    flag = False
                    PY_LOGGER.info("There is an error in Sequence[22]!")
                    if "zh" == lang:
                        errMsg = u"\n获取信息出错。"
                    else:
                        errMsg = "\nThere is an error in getting information."
                    return (flag, cliRet, errMsg)
                list2 = field.split()
                if len(list2)!= 6:
                    continue
                if list2[1] != "Normal":
                    flag = False
                    PY_LOGGER.info("Sequence[22] Normal num in A is not equal B~~~over!")
                    if "zh" == lang:
                        errMsg += u"\nPCIE端口状态异常"
                    else:
                        errMsg += "\nThe port of PCIE is abnormal"
                        
        #如果“Error”出现在命令的6个端口外，比如命令超时，就不会打印那6个端口信息
        if True == isErrorOutOfPort:
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", cliRet, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[22]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
        
        return (flag, cliRet, errMsg)
                                   
    except Exception, exception:
        PY_LOGGER.error("Sequence[22] catch except of when check FC port."+str(chkfc_start)+"~~~"+str(find_flag)+"~~~~over!")
        PY_LOGGER.error("Sequence[22] catch except of check disk NCQ status.")
        PY_LOGGER.error("Sequence[22] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[22] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[22] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
