# -*- coding: UTF-8 -*-
import traceback
import re
G_ITEM_NUM_CONTROLLER = 2
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show system general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show controller general")
        PY_LOGGER.info("\nSequence[24] execute command result:\n" + cliRet)
        cliRetLast = ""
        
        list = cliRet.splitlines()
        
        strList = []
        for field in list:
            field = field.replace(" ", "")
            
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[24] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[24]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
                
            if field.startswith("Controller"):
                temp = field.split(":")
                PY_LOGGER.info("Controller ID is:" + temp[1])
                strList.append(temp[1])
        for controllerID in strList:
            cliRet_DirtyRate = ""
            cliRet_DirtyRate = cli.execCmd("show controller general " + "controller=" + controllerID)
            cliRetLast = cliRetLast + cliRet_DirtyRate
            PY_LOGGER.info("\nSequence[24] execute command result:\n" + cliRet_DirtyRate)
            list2 = cliRet_DirtyRate.splitlines()

            for field in list2:
                field = field.replace(" ", "")

                if field.startswith("-bash") or field.startswith("upgrade"):
                    flag = False
                    PY_LOGGER.info("Sequence[24] not in CLI mode, out!")
                    if "zh" == lang:
                        errMsg = u"\n系统没有运行在admin模式"
                    else:
                        errMsg = "\nSystem is not in admin Mode"
                    return (flag, cliRetLast, errMsg)

        return (flag, cliRetLast)
    except Exception, exception:
        PY_LOGGER.error("Sequence[24] catch except of check controller status.")
        PY_LOGGER.error("Sequence[24] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[24] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[24] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
            
        return (flag, cliRetLast, errMsg)
