# -*- coding: UTF-8 -*-
import traceback
import re
G_ITEM_NUM_CONTROLLER = 2
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show system general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show controller general")
        PY_LOGGER.info("\nSequence[25] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        strList = []
        cliRetLast = ""
        
        for field in list:
            field = field.replace(" ","")
            
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[25] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[25]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)    
            
            if field.startswith("Controller"):
                temp = field.split(":")
                PY_LOGGER.info("Controller ID is:" + temp[1])
                strList.append(temp[1])
                
        for controllerID in strList:
            cliRet_DirtyRate = ""
            cliRet_DirtyRate = cli.execCmd("show controller io io_type=frontEnd " + "controller_id=" + controllerID)
            cliRetLast = cliRetLast + cliRet_DirtyRate
            PY_LOGGER.info("\nSequence[25] execute command result:\n" + cliRet_DirtyRate)
            list2 = cliRet_DirtyRate.splitlines()

            for field in list2:
                field = field.replace(" ","")

                if field.startswith("-bash") or field.startswith("upgrade"):
                    flag = False
                    PY_LOGGER.info("Sequence[25] not in CLI mode, out!")
                    if "zh" == lang:
                        errMsg = u"\n系统没有运行在admin模式"
                    else:
                        errMsg = "\nSystem is not in admin Mode"
                    return (flag, cliRetLast, errMsg)

                if len(list2) < 4:
                    flag = False
                    PY_LOGGER.info("The frontEnd is not find right.")
                    if "zh" == lang:
                        errMsg = u"\n未正常查询前端并发数"
                    else:
                        errMsg = "\nThe Front End IO does not query correctly."
                    return (flag, cliRetLast, errMsg)
        return (flag, cliRetLast)

    except Exception, exception:
        PY_LOGGER.error("Sequence[25] catch except of check controller status.")
        PY_LOGGER.error("Sequence[25] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[25] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[25] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
            
        return (flag, cliRetLast, errMsg)
