# -*- coding: UTF-8 -*-
import traceback
import re

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show system general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show disk health")
        PY_LOGGER.info("\nSequence[27] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        diskId = ""
        healthMask = ""
        for field in list:
            field = field.replace(" ","")
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[27] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)

            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[27]!")
                if "zh" == lang:
                    errMsg = u"\n查询硬盘健康状态失败。"
                else:
                    errMsg = "\nCheck disk health mask information error."
                return (flag, cliRet, errMsg)
            
            #获取硬盘ID
            if field.startswith("DiskID"):
                diskId = field.replace("DiskID:", "")
            
            #获取健康度的值
            if field.startswith("HealthMark"):
                healthMask = field.replace("HealthMark:", "")
                
            #判断健康度的值
            if diskId != "" and healthMask != "":
                #获取健康值失败
                if healthMask in ["255", "--"]:
                    PY_LOGGER.info("Sequence[27] diskId ["+diskId+"] Health Mark is:" + healthMask)
                  
                #健康分值小于等于60，检查不通过
                elif int(field.replace("HealthMark:", "")) <= 60:
                    flag = False
                    PY_LOGGER.info("Sequence[27] Health Mark is:" + field + "~~~over!")
                    if "zh" == lang:
                        errMsg += u"\n硬盘" + diskId + u"的健康状态不正常（" + healthMask + u"）"
                    else:
                        errMsg += "\nThe health mark of disk " + diskId + " is abnormal(" + healthMask + u")"
                
                #重新初始化变量
                diskId = ""
                healthMask = ""
                
        return (flag, cliRet, errMsg)
    except Exception, exception:
        PY_LOGGER.error("Sequence[27] catch except of check controller status.")
        PY_LOGGER.error("Sequence[27] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[27] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[27] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
            
        return (flag, cliRet, errMsg)
