# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check hotspare spaces
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show storage_pool general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = cli.execCmd("show disk_domain general")
        PY_LOGGER.info("\nSequence[64] execute command result:\n" + cliRet)
        list = cliRet.splitlines()
        i = 0
        for field in list:
            #Need enter to CLI and must in normal mode.
            list1 = field.split()
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[64] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[64]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            i = i + 1
            
            if i > 4:
                if len(list1) < 4:
                    continue
                
                if list1[7] != "0.000B":
                    PY_LOGGER.info(" Used Hot Spare Capacity:" + list1[7])
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\nDomain[" + list1[0] + u"]的Hotspare Used Capacity不为0"
                    else:
                        errMsg += "\nThe Used Hot Spare Capacity in domain[" + list1[0] + "] is not 0"

        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[64] catch except of check hotspare spaces.")
        PY_LOGGER.error("Sequence[64] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[64] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[64] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet1 + cliRet, errMsg)
