# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : check LUN write policy
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show lun lun_id=LUN_ID")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        filterCmd1 = "|filterRow column=Write\sPolicy predict=equal_to value=Write\sBack logicOp=and column=Running\sWrite\sPolicy predict=not predict2=equal_to value=Write\sBack"
        filterCmd2 = "|filterRow column=Write\sPolicy predict=equal_to value=Write\sThrough logicOp=and column=Running\sWrite\sPolicy predict=not predict2=equal_to value=Write\sThrough"
        
        #If more than 3 lines its means have not equal value
        cliRet1 = cli.execCmd("show lun general " + filterCmd1)
        PY_LOGGER.info("\nSequence[68] execute command result:\n" + cliRet1)
        cliRet2 = ""
        list = cliRet1.splitlines()
        i = 0
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[68] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet1, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[68]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            i = i + 1
            
        if i > 3:
            flag = False
            if "zh" == lang:
                errMsg = u"\nLun的写策略与运行写策略不一致"
            else:
                errMsg = "\nThe write policy of lun is not consistent with running write policy"
            return (flag, cliRet1, errMsg)
    
        #If more than 3 lines its means have not equal value
        cliRet2 = cli.execCmd("show lun general " + filterCmd2)
        list = cliRet2.splitlines()
        i = 0
        for field in list:
            i = i + 1
        if i > 3:
            flag = False
            if "zh" == lang:
                errMsg = u"\nLun的写策略与运行写策略不一致"
            else:
                errMsg = "\nThe write policy of lun is not consistent with running write policy"
            return (flag, cliRet1+cliRet2, errMsg)

        return (flag, cliRet1+cliRet2)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[68] catch except of check LUN write policy.")
        PY_LOGGER.error("Sequence[68] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[68] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[68] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet1+cliRet2, errMsg)
