# -*- coding: UTF-8 -*-
import traceback
import re 

def execute(cli):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : check LUN controller
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show lun lun_id=LUN_ID")
    Return             : the checkitem is pass;cli source info
    """
    try:
        lang = py_java_env.get("lang")
        errMsg = ""
        flag = True
        errCounter = 0
        
        cliRet = cli.execCmd("show lun general")
        PY_LOGGER.info("\nSequence[69] execute command result:\n" + cliRet)
        list = cliRet.splitlines()
        i = 0
        for field in list:
            if i < 4:
                #Need enter to CLI and must in normal mode.
                if field.startswith("-bash") or field.startswith("upgrade"):
                    flag = False
                    PY_LOGGER.info("Sequence[69] not in CLI mode, out!")
                    if "zh" == lang:
                        errMsg = u"\n系统没有运行在admin模式"
                    else:
                        errMsg = "\nSystem is not in admin Mode"
                    return (flag, cliRet, errMsg)
                #其它出现“Error:”字眼的信息视为不通过
                if re.search("Error:", field, re.IGNORECASE):
                    flag = False
                    if "zh" == lang:
                        errMsg = u"\n获取Lun信息出错。"
                    else:
                        errMsg = "\nThere is an error in getting Lun information."
                    return (flag, cliRet, errMsg)

                
                i += 1
            
            else:
                if re.search(':/>', field, re.IGNORECASE): 
                    break
                
                luninfo = field.split()
                lunId=luninfo[0]
                #传给工具方法处理
                ret = isLunControllerSame(cli, lunId, lang)
                
                if not ret[0]:
                    #控制检查项原始信息：
                    #最多显示10个不通过的Lun的详细回文信息
                    errCounter += 1
                    if errCounter <= 10:
                        cliRet += "\n" + ret[1]

                    errMsg += ret[2]
                    flag = False
                    
                else:
                    continue
                
        return(flag, cliRet, errMsg)
    
    except Exception, exception:
        flag = False 
        PY_LOGGER.error("Sequence[69] catch except of check LUN controller.")
        PY_LOGGER.error("Sequence[69] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[69] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[69] catch except of trace back:" + str(traceback.print_exc()))
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)

#*****************************************************************************#
#函数描述：根据LUNID判断归属、工作控制器是否一致
#参数说明：cli连接，LunId,lang语言
#返回值  ：True or False , 回文 ,描述
#*****************************************************************************#
def isLunControllerSame(cli, lunId, lang):
    ownerControllerId = ''
    workControllerId = ''
    
    cmd = 'show lun general lun_id=' + lunId
    
    cliRet = cli.execCmd(cmd)
    PY_LOGGER.info("\nSequence[69] execute command result:\n" + cliRet)
    list = cliRet.splitlines()
    i = 0
    for line in list:#循环取出归属控制器和工作控制器
        i += 1
        if i <= 4:
            #Need enter to CLI and must in normal mode.
            if line.startswith("-bash") or line.startswith("upgrade"):
                PY_LOGGER.info("Sequence[69] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (False, cliRet, errMsg)
            
            if re.search("Error:", line, re.IGNORECASE):
                if "zh" == lang:
                    errMsg = u"\nLun归属（ id:"  + lunId + u" )异常。"
                else:
                    errMsg = "\nLun ownership(id:" + lunId + ") is abnormal."
                return (False, cliRet, errMsg)
        
        if re.search('Owner Controller', line, re.IGNORECASE):
            ownerControllerId = line.split(':')[1].strip()
        if re.search('Work Controller', line, re.IGNORECASE):
            workControllerId = line.split(':')[1].strip()
            
    if ownerControllerId == '' or workControllerId == '':#如果有一控没有则返回
        if "zh" == lang:
            errMsg = u"\nLunId:" + lunId + u"信息异常。"
        else:
            errMsg = "\nLunId:" + lunId + " information is abnormal"
        PY_LOGGER.info("Sequence[69] LunId:" + lunId + " information is abnormal")
        return (False, cliRet, errMsg)
    
    if ownerControllerId != workControllerId:#比较两个控制器
        PY_LOGGER.info("Sequence[69] LunId:"+ lunId +" owner controller is not consistent with work controller")
        if "zh" == lang:
            errMsg = u"\nLunId:" + lunId + u"的工作控制器和归属控制器不一致"
        else:
            errMsg = "\nLunId:" + lunId + " owner controller is not consistent with work controller"
        return (False, cliRet, errMsg) 
    return (True, '', '')
    