# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showdisk -physic")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        filterCmd = "|filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online"
        cliRet = cli.execCmd("show disk general " + filterCmd)
        PY_LOGGER.info("\nSequence[7] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        i = 0
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[7] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[7]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            i = i + 1
            
            #If more than 3 lines its means have fault or offline disk
            if i > 3:
                flag = False
                
                if -1 != field.find("----"):
                    continue
                    
                list2 = field.split()
                if len(list2) < 4:
                    continue
                diskID = list2[0]
                if "zh" == lang:
                    errMsg += u"\n硬盘[" + diskID + u"]状态存在异常"
                else:
                    errMsg += "\nThe status of disk[" + diskID + "] is abnormal"   
        
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[7] catch except of check disk status.")
        PY_LOGGER.error("Sequence[7] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[7] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[7] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
