# -*- coding: UTF-8 -*-
import traceback
import re

#################################################################
# 函数名称：getColValue
# 功能说明：根据列号获取列值
# 传入参数：字符串line，列号colNum
# 返 回  值：列号所对应的列值
#################################################################
def getColValue(line, colNum):
    colValue = ""
    colList = line.split("  ")
    count = 0
    for tempCol in colList:
        if "" != tempCol:
            count += 1
            if colNum == count:
                colValue = tempCol.strip()
                break
    return colValue
	
def execute(cli):
    """
    Create date        : 2014/03/12
    Function name      : execute(cliConnection)
    Function describe  : check mirror general status
    Input              : cli--Telnet acess proxy 
                         e.g: cliRet = cli.execCmd("show lun_migration general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = cli.execCmd("show lun_migration general")
        PY_LOGGER.info("\nSequence[88] execute command result:\n" + cliRet)
        
        cliRetList = cliRet.splitlines()
		#能够查询到LUN迁移信息
        if re.search("Source LUN ID", cliRet, re.IGNORECASE) and re.search("Running Status", cliRet, re.IGNORECASE):
            isSwitchOn = False
            for line in cliRetList:
                #找到"---"后打开开关，并在下一行开始
                if re.search("---", line, re.IGNORECASE):
                    isSwitchOn = True
                    continue
                #找到":/>"则退出
                if re.search(":/>", line, re.IGNORECASE):
                    break
                #如果是空行，则继续
                if "" == line.strip():
                    continue
                #开关打开，表示有效行（即在"---"和":/>"之间的非空白行）
                if isSwitchOn:
                    id = getColValue(line, 1)
                    runningStatus = getColValue(line, 5)
                    if "Fault" == runningStatus:            
                        PY_LOGGER.info("Sequence[88] inspect lun_migration general status:" + runningStatus + " Source LUN ID: " + id)
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\nLUN迁移[源LUN ID:" + id + u"]状态检测异常" 
                        else:
                            errMsg += "\nThe status of lun migration[source lun id:" + id + "] is abnormal"
        else:#不能查询到LUN迁移信息
            for line in cliRetList:
                #系统没有运行在admin模式
                if line.startswith("-bash") or line.startswith("upgrade"):
                    flag = False
                    PY_LOGGER.info("Sequence[88] not in CLI mode, out!")
                    if "zh" == lang:
                        errMsg = u"\n系统没有运行在admin模式"
                    else:
                        errMsg = "\nSystem is not in admin Mode"
                    return (flag, cliRet, errMsg)
                
                if re.search("license", line, re.IGNORECASE):       
                    continue
                
                #其它出现“Error:”字眼的信息视为不通过
                if re.search("Error:", line, re.IGNORECASE):
                    flag = False
                    PY_LOGGER.info("There is an error in Sequence[88]!")
                    if "zh" == lang:
                        errMsg = u"\n获取信息出错。"
                    else:
                        errMsg = "\nThere is an error in getting information."
                    return (flag, cliRet, errMsg)

        return (flag, cliRet, errMsg)
        
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[88] catch except of check mirror general status.")
        PY_LOGGER.error("Sequence[88] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[88] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[88] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)

