# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18,Modify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : execute critical alarm check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show system general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = cli.execCmd("show alarm level=critical number=10")
        PY_LOGGER.info("\nSequence[91] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        i = 0
        for field in list:
            field = field.replace(" ", "")
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[91] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[91]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("Commandexecutedsuccessfully"):
                flag = True
                return (flag, cliRet)
            
            i = i + 1
        #If more than 3 lines its means have critical alarm
        if i > 3:
            flag = False
            if "zh" == lang:
                errMsg = u"\n系统存在紧急告警"
            else:
                errMsg = "\nSystem exists critical alarm"
            return (flag, cliRet, errMsg)
        return (flag, cliRet)

    except Exception, exception:
        PY_LOGGER.error("Sequence[91] catch except of check critical alarm.")
        PY_LOGGER.error("Sequence[91] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[91] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[91] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
