# -*- coding: UTF-8 -*-

import traceback
import util
import commonFunction

def execute(cli):
    '''
    @summary: 检查项入口函数
    '''
    lang = py_java_env.get("lang")
    logger = PY_LOGGER
    cliRet = ""
    errMsg = ""
    all4kDiskList = []
    bugProductModelList = ['S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T']
    bugVersionList = ["V200R002C10"]
    checkRet = True
      
    #检查产品型号
    result, cmdRet, productModel = commonFunction.getProductModel(cli, logger)
    cliRet += cmdRet
    if not result:
        if "zh" == lang:
            errMsg = u"\查询产品型号失败。"
        else:
            errMsg = u"\nFailed to query the product model."
        return (False, cliRet, "")
    
    if productModel not in bugProductModelList:
        return ("NOSUPPORT", cliRet, "")
    
    #检查产品版本号
    getSucc, sysVerCliRet, fullVer = commonFunction.getProductFullVersion(cli, logger)
    cliRet += sysVerCliRet
    if not getSucc:
        if "zh" == lang:
            errMsg += u"\n查询系统版本号失败。"
        else:
            errMsg += u"\nFailed to query the system product version."
        return (False, cliRet, errMsg) 
    
    if fullVer not in bugVersionList:
        return (True, cliRet, errMsg)
    
    #获取硬盘扇区大小
    result, cmdRet, sectorSizeDictList, errMsgDict = commonFunction.getDiskSectorSize(cli, logger)
    cliRet += cmdRet
    if not result:
        if "zh" == lang:
            errMsg += errMsgDict.get("zh")
        else:
            errMsg += errMsgDict.get("en")
        return (False, cliRet, errMsg)
    
    #检查扇区大小是否为4096B或4160B
    result, is4KDiskListSecSize, errMsgDict = commonFunction.is4KDiskWithSectorSize(sectorSizeDictList)
    all4kDiskList += is4KDiskListSecSize
    if "zh" == lang:
        errMsg += errMsgDict.get("zh")
    else:
        errMsg += errMsgDict.get("en")
    if result:
        checkRet = False
    
    #检查大于1TB的SAS盘或5TB的NearLine SAS盘
    result, cmdRet, errMsgDict, is4kDiskListCup = commonFunction.get4kDiskInfo(cli, logger)
    cliRet += cmdRet
    all4kDiskList += is4kDiskListCup
    if "zh" == lang:
        errMsg += errMsgDict.get("zh")
    else:
        errMsg += errMsgDict.get("en")
    if not result:
        checkRet = False
    
    #汇总后所有4K盘信息
    if all4kDiskList:
        checkRet = False  
    
    return (checkRet, cliRet, errMsg)
    
    
    
