"""
@version: Toolkit V200R006C00
@time: 2019/10/08
@file: hardware_root_disk_check.py
@function:
@modify:
"""
import cliCmdManager
import commonFunction
import cliModeManager
from toolutilities import sshutils
from commonFunction import copyDevNode
from constant import CLI_CMD
from commonFunction import getCtrlCmdMode
from constant import SSH_CLI_MODEL_TYPE
import util
import re

PY_JAVA_ENV = py_java_env
LANG = py_java_env.get("lang")
LOGGER = PY_LOGGER
MOUNT = 'mount'
COFFER_LOG = 'ls /OSM/coffer_log'
CCDB_STORE = 'ls /OSM/ccdb/store'
RW_AUTH_DISK_DIR_LIST = ['/OSM/coffer_log', '/startup_disk/conf',
                         '/OSM/coffer_data']
# TV2需要检查的系统型号
tv2_check_system_type = {'S5600T', 'S5800T', 'S6800T'}
mount_disk_check_dict = {'/startup_disk/image': 'N',
                         '/startup_disk/conf': 'N', '/OSM/coffer_log': 'N',
                         '/OSM/coffer_data': 'N'}
ccdb_file_check = False


def execute(cli):
    global ccdb_file_check
    all_cli_ret = ''
    dev_node = PY_JAVA_ENV.get("devInfo")
    current_ip = dev_node.getIp()
    usr_pwd = dev_node.getLoginUser().getPassword()
    dev_pwd = unicode(PY_JAVA_ENV.get("devPwd").get("developer"))
    try:
        # 获取系统版本
        product_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
        product_version = str(
            PY_JAVA_ENV.get("devInfo").getProductVersion())
        LOGGER.info("productModel is: %s, productVersion:%s" % (
            product_model, product_version))
        # show upgrade package
        cmd_exe_succ, cli_ret = cliCmdManager. \
            execCmdWithTimout(cli, CLI_CMD.SHOW_UPGRADE_PACKAGE, LOGGER)
        all_cli_ret += cli_ret
        # 版本判断
        if not check_system_type_version(product_model, product_version):
            return 'NOSUPPORT', all_cli_ret, ''
        if dev_pwd is None:
            return False, all_cli_ret, util.get_message(
                LANG, LOGGER, 'debug.pwd.error')
        # 所有引擎，所有控制器下系统盘检查
        all_engine_check_flag, all_engine_check_ret, engine_check_error \
            = check_all_engine_root_disk_status(cli, current_ip, dev_pwd,
                                                usr_pwd)
        all_cli_ret += all_engine_check_ret
        return (
            all_engine_check_flag, all_cli_ret,
            engine_check_error)
    except Exception as ex:
        LOGGER.error("Failed to check root disk :%s" % str(ex))
        return (
            commonFunction.NOCHECK, all_cli_ret,
            util.get_message(LANG, LOGGER, 'query.result.abnormal'))
    return True, all_cli_ret, ''


def check_system_type_version(product_model, product_version):
    """
    涉及产品版本及型号判断,
        TV2系列：V200R002C00及后续版本,型号S5600T&S5800T&S6800T
    :param product_model: 型号
    :param product_version: 版本
    :return: 是否涉及T,F
    """
    model = product_model.upper()
    version = product_version.upper()
    if version.startswith('V200R') and version >= 'V200R002C00' \
            and model in tv2_check_system_type:
        return True
    return False


def check_all_engine_root_disk_status(cli, current_ip, dev_pwd, usr_pwd):
    """
     检查所有引擎所有控制器系统盘状态
    :param cli: cli
    :param current_ip:current_ip
    :param dev_pwd: debug密码
    :param usr_pwd: 用户密码
    :return:T F
    """
    cli_ret = ''
    controller_cli_ret = cli.execCmd("show controller ip")
    cli_ret += controller_cli_ret
    controller_ip_dict = util.formatDict(controller_cli_ret)
    ip_pair_list = get_controller_ip(controller_ip_dict)
    LOGGER.info('IP List:%s' % unicode(ip_pair_list))
    err_msg = ''
    # 将检查结果存为字典，key是ip，value是检查结果的布尔值
    check_ctrls_result_map = {}
    for engine_ip_pair in ip_pair_list:
        # 第一个引擎
        if current_ip in engine_ip_pair:
            # 本端
            check_cli_ret, check_err_msg, check_ctrls_result_map = \
                check_local_engine(cli, dev_pwd, usr_pwd, current_ip,
                                   check_ctrls_result_map, engine_ip_pair)
            cli_ret += check_cli_ret
            err_msg += check_err_msg
        else:  # 其他引擎（双控节点）
            check_flag, check_cli_ret, check_err_msg = \
                check_other_engine(engine_ip_pair, check_ctrls_result_map,
                                   usr_pwd,
                                   dev_pwd)
            cli_ret += check_cli_ret
            err_msg += check_err_msg
            if check_flag is not True:
                continue
    LOGGER.info(
        "FinalCheckResultFlagMap:" + unicode(check_ctrls_result_map))
    for key in check_ctrls_result_map:
        result_val_flag = check_ctrls_result_map.get(key)
        if not result_val_flag:
            return False, cli_ret, err_msg
    return True, cli_ret, err_msg


def check_local_engine(cli, dev_pwd, usr_pwd, current_ip,
                       check_ctrls_result_map, engine_ip_pair):
    """
    检查本引擎
    :param cli: cli
    :param dev_pwd: dev_pwd
    :param usr_pwd: usr_pwd
    :param current_ip: current_ip
    :param check_ctrls_result_map: check_ctrls_result_map
    :param engine_ip_pair: engine_ip_pair
    :return: cli_ret, err_msg, check_ctrls_result_map
    """
    cli_ret = ''
    err_msg = ''
    flag_item, cli_ret_item, err_msg_item = \
        check_each_engine_root_disk_status(
            cli, dev_pwd, current_ip)
    cli_ret += cli_ret_item
    check_ctrls_result_map[current_ip] = flag_item
    err_msg += err_msg_item
    engine_ip_pair.remove(current_ip)

    if len(engine_ip_pair) > 0:
        # 心跳到对端
        peer_ip = engine_ip_pair[0]
        peer_flag, peer_cli_ret, peer_error = \
            check_peer_ctrl_process(cli, usr_pwd, dev_pwd, peer_ip)
        check_ctrls_result_map[peer_ip] = peer_flag
        cli_ret += peer_cli_ret
        err_msg += peer_error
    final_cli_mode = cliModeManager. \
        change_any_model_to_cli_with_log(cli, LOGGER)
    if final_cli_mode == SSH_CLI_MODEL_TYPE.SSH_MINISYSTEM_MODEL:
        LOGGER.error('Exit minisystem mode failed!')
        err_msg += util.get_message(
            LANG, LOGGER, 'exit.minisystem.mode.failed', current_ip)
        check_ctrls_result_map[current_ip] = False
    return cli_ret, err_msg, check_ctrls_result_map


def check_other_engine(engine_ip_pair, check_ctrls_result_map, usr_pwd,
                       dev_pwd):
    """
    检查其他引擎
    :param engine_ip_pair:
    :param check_ctrls_result_map:
    :param usr_pwd:
    :param dev_pwd:
    :return: flag, cli_ret, err_msg
    """
    err_msg = ''
    cli_ret = ''
    ip_num = len(engine_ip_pair)
    if ip_num == 1:
        # 单控
        LOGGER.info('This engine has only one controller!')
        local_ip = engine_ip_pair[0]
        local_cli = create_ssh_connection(local_ip)

        if not local_cli:
            check_ctrls_result_map[local_ip] = False
            err_msg += util.get_message(
                LANG, LOGGER, 'fail.to.create.ssh.connection',
                local_ip)
            return False, cli_ret, err_msg
        else:
            flag_item, cli_ret_item, err_msg_item = \
                check_each_engine_root_disk_status(
                    local_cli, dev_pwd, local_ip)
            cli_ret += cli_ret_item
            check_ctrls_result_map[local_ip] = flag_item
            err_msg += err_msg_item
            final_cli_mode = cliModeManager. \
                change_any_model_to_cli_with_log(local_cli, LOGGER)
            if final_cli_mode == SSH_CLI_MODEL_TYPE. \
                    SSH_MINISYSTEM_MODEL:
                LOGGER.error('Exit minisystem mode failed!')
                err_msg += util.get_message(
                    LANG, LOGGER,
                    'exit.minisystem.mode.failed',
                    local_ip)
                check_ctrls_result_map[local_ip] = False
            local_cli.close()
    elif ip_num == 2:
        # 双控
        local_ip = engine_ip_pair[0]
        peer_ip = engine_ip_pair[1]
        cli_con = create_ssh_connection(local_ip)
        if not cli_con:
            cli_con = create_ssh_connection(peer_ip)
            if not cli_con:
                err_msg += \
                    util.get_message(
                        LANG, LOGGER,
                        'create.local.to.peer.ssh.connection.fail',
                        (local_ip, peer_ip))

                check_ctrls_result_map[local_ip] = False
                check_ctrls_result_map[peer_ip] = False
                return False, cli_ret, err_msg
            else:
                local_ip, peer_ip = peer_ip, local_ip
        flag_item, cli_ret_item, err_msg_item = \
            check_each_engine_root_disk_status(cli_con,
                                               dev_pwd, local_ip)
        cli_ret += "\nController " + local_ip + ":\n" + cli_ret_item
        check_ctrls_result_map[local_ip] = flag_item
        err_msg += err_msg_item

        # 心跳到对端检查对端控制器进程
        peer_flag, peer_cli_ret, peer_error = \
            check_peer_ctrl_process(cli_con, usr_pwd, dev_pwd,
                                    peer_ip)
        check_ctrls_result_map[peer_ip] = peer_flag
        cli_ret += peer_cli_ret
        err_msg += peer_error

        final_cli_mode = cliModeManager.change_any_model_to_cli_with_log(
            cli_con, LOGGER)
        if final_cli_mode == \
                SSH_CLI_MODEL_TYPE.SSH_MINISYSTEM_MODEL:
            LOGGER.error('Exit minisystem mode failed!')
            err_msg += util.get_message(
                LANG, LOGGER, 'exit.minisystem.mode.failed',
                peer_ip)
            check_ctrls_result_map[local_ip] = False
        cli_con.close()
    else:
        LOGGER.error('Wrong IP number!')
    return True, cli_ret, err_msg


def check_each_engine_root_disk_status(cli, dev_pwd, ctrl_ip):
    """
    检查某控下系统盘是否正常
    :param cli: cli
    :param dev_pwd:dev_pwd
    :param ctrl_ip:当前控制器IP
    :return:T F
    """
    global ccdb_file_check
    all_cli_ret = ''
    if not cliModeManager.change_climodel_to_minisystem(cli, PY_JAVA_ENV,
                                                        dev_pwd, LOGGER):
        return False, all_cli_ret, util.get_message(
            LANG, LOGGER, 'enter.minisystem.error')
    # mount目录检查
    mount_flag, mount_cli_ret, mount_error = check_root_disk_mount(cli)
    all_cli_ret += mount_cli_ret
    if mount_flag is not True:
        return mount_flag, all_cli_ret, \
               get_each_ctrl_check_error(ctrl_ip,
                                         mount_error)
    # /OSM/coffer_log目录检查
    coffer_log_cli_ret = cli.execCmd(COFFER_LOG)
    all_cli_ret += coffer_log_cli_ret
    if check_if_directory_empty(coffer_log_cli_ret, COFFER_LOG):
        check_error = util.get_message(
            LANG, LOGGER, "root.disk.check.mount.directory.empty",
            '/OSM/coffer_log')
        return False, all_cli_ret, get_each_ctrl_check_error(ctrl_ip,
                                                             check_error)
    return True, all_cli_ret, ''


def check_peer_ctrl_process(local_cli, usr_pwd, dev_pwd, peer_ip):
    """
    心跳到对端检查
    :param local_cli:cli
    :param usr_pwd:usr_pwd
    :param dev_pwd:dev_pwd
    :param peer_ip:对端ip
    :return:T F
    """
    cli_ret = ''
    err_msg = ''
    model = getCtrlCmdMode(local_cli, LOGGER)
    if model != SSH_CLI_MODEL_TYPE.SSH_MINISYSTEM_MODEL:
        LOGGER.error('Current CLI mode is not minisystem, return!')
        return False, cli_ret, err_msg

    if cliModeManager.heart_beat_to_peer(local_cli, usr_pwd, LOGGER):
        LOGGER.info('Heart beat to peer successfully!')
    else:
        return (False, cli_ret,
                util.get_message(LANG, LOGGER, 'heart.beat.to.peer.failed',
                                 unicode(peer_ip)))
    try:
        flag, cli_ret_item, err_msg = check_each_engine_root_disk_status(
            local_cli, dev_pwd, peer_ip)
        cli_ret += "\nController " + peer_ip + ":\n" + cli_ret_item
    except Exception, e:
        flag = False
        LOGGER.error('Check process exception:' + unicode(e))
    finally:
        cliModeManager.exit_from_peer_minisystem(local_cli)
    return flag, cli_ret, err_msg


def get_each_ctrl_check_error(current_ctrl_ip, error):
    return util.get_message(LANG, LOGGER,
                            "root.disk.check.engine.controller.disk.error",
                            (current_ctrl_ip, error))


def check_root_disk_mount(cli):
    """
    mount命令检查系统盘目录挂载情况
    :param cli:cli
    :return: flag,cli_ret,error
    """
    mount_cli_ret = cli.execCmd(MOUNT)
    res_lines = mount_cli_ret.splitlines()
    check_dict = mount_disk_check_dict.copy()
    for line in res_lines:
        mount_disk_check(check_dict, line)
    return mount_disk_check_result(check_dict, mount_cli_ret)


def mount_disk_check(check_dict, line):
    """
    检查每一行是否包含待检测目录
    :param check_dict:待检测目录
    :param line:mount命令回显行
    :return: no return
    """
    for dir_name in mount_disk_check_dict:
        # 该目录已经判断存在，跳过
        if check_dict[dir_name] == 'Y':
            continue
        if target_directory_in_line(line, dir_name):
            if 'rw' in line:
                check_dict[dir_name] = 'Y'
            else:
                check_dict[dir_name] = \
                    util.get_message(
                        LANG,
                        LOGGER,
                        "root.disk.check.mount.coffer.log.auth.error", dir_name)
        else:
            if directory_in_line(dir_name, line):
                check_dict[dir_name] = 'Y'


def target_directory_in_line(line, dir_name):
    """
    做判断/OSM/coffer_log，/startup_disk/conf文件夹是否存在
    :param line: 行
    :return: 结果
    """
    if dir_name in RW_AUTH_DISK_DIR_LIST and directory_in_line(dir_name, line):
            return True
    return False


def directory_in_line(dic_name, line):
    """
    全匹配文件名是否存在
    :param dic_name: 文件名
    :param line: 行
    :return: T F
    """
    result = re.search(r'\s+' + dic_name + r'\s+', line)
    if result is not None:
        return True
    else:
        return False


def mount_disk_check_result(check_dict, mount_cli_ret):
    """
    检查所有待检查目录校验结果
    :param check_dict:待检测目录
    :param mount_cli_ret:mount回显
    :return:flag,cli_ret,error
    """
    error = ''
    flag = True
    for key in check_dict:
        if check_dict[key] == 'Y':
            continue
        if check_dict[key] == 'N':
            flag = False
            error += util.get_message(
                LANG, LOGGER,
                "root.disk.check.mount.error.nodirectory",
                str(key))
        else:
            flag = False
            error += str(check_dict[key])
    return flag, mount_cli_ret, error


def check_if_directory_empty(cli_ret, cmd):
    """
    判断ls查询目录回显的子目录是否为空
    :param cli_ret:ls xxx 回显
    :param cmd:ls xxx命令
    :return: 是否为空
    """
    cli_lines = cli_ret.splitlines()
    for line in cli_lines:
        # 过滤回显命令行和命令行执行异常
        if cmd in line:
            continue
        # 包含结束符，和异常结果关键字，跳过
        if 'minisystem>' in line.lower() or 'no such file or directory' \
                in line.lower() or 'permission denied' in line.lower():
            continue
        # 正常目录
        if bool(line.strip()):
            return False
    return True


def get_controller_ip(controller_ip_dict):
    """
    获取控制器IP
    :param controller_ip_dict:控制器-ip映射
    :return:控制器IP
    """
    controller_ip_list = []
    controller_0 = []
    controller_1 = []
    if type(controller_ip_dict) != dict:
        for controller_ip_info in controller_ip_dict:
            controller_id = controller_ip_info.get("Controller")
            ip = controller_ip_info.get("IPv4 Address")
            if controller_id.startswith("0"):
                controller_0.append(ip)
            elif controller_id.startswith("1"):
                controller_1.append(ip)
    else:
        controller_id = controller_ip_dict.get("Controller")
        ip = controller_ip_dict.get("IPv4 Address")
        if controller_id.startswith("0"):
            controller_0.append(ip)
        elif controller_id.startswith("1"):
            controller_1.append(ip)
    if controller_0:
        controller_ip_list.append(controller_0)
    if controller_1:
        controller_ip_list.append(controller_1)
    return controller_ip_list


def create_ssh_connection(ip_address):
    """
    创建其他控制器SSH连接
    :param ip_address:控制器IP
    :return:连接cli
    """
    dev_node = PY_JAVA_ENV.get("devInfo")
    my_dev_node = copyDevNode(dev_node)
    my_dev_node.setIp(ip_address)
    try:
        cli_con = sshutils.createSSHConnectionByDevNode(my_dev_node)
        cli_con.connect()
    except Exception as ex:
        LOGGER.error(
            "Create SSH [" + ip_address + "] connection catch exception:" +
            unicode(ex))
        return None
    else:
        return cli_con
