# coding: UTF-8

import re
import cliCmdManager
from constant import CLI_CMD
from constant import TOOLKIT_SEND_CMD_TIME_OUT
from commonFunction import getCtrlCmdMode


def change_cli2_developer(ssh, dev_passwd, logger):
    """
            函数名称: changeCli2Developer
            功能说明: 从CLI模式进入developer模式（需要确定使用之前为CLI模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    """

    ret = cliCmdManager.execCmd(ssh, CLI_CMD.SWITCH_TO_DEVELOPER, logger)
    if not ret[0]:
        return False

    temp = ret[1]
    # 判断是否已经developer模式
    if re.search("Password", temp, re.IGNORECASE):
        temp = ssh.execCmdNoLog(dev_passwd)
        if re.search("developer", temp, re.IGNORECASE):
            return True

    # 进入developer模式失败，重新回到CLI模式
    change_any_model_to_cli(ssh)
    return False


def change_cli2_developer_with_cli_ret(ssh, dev_passwd, logger):
    """
            函数名称: changeCli2Developer
            功能说明: 从CLI模式进入developer模式（需要确定使用之前为CLI模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    """

    ret = cliCmdManager.execCmd(ssh, CLI_CMD.SWITCH_TO_DEVELOPER, logger)
    if not ret[0]:
        return ret

    temp = ""
    # 判断是否已经developer模式
    if re.search("Password", temp, re.IGNORECASE):
        temp = ssh.execCmdNoLog(dev_passwd)
        if re.search("developer", temp, re.IGNORECASE):
            return True, ret[1] + "\n" + temp

    # 进入developer模式失败，重新回到CLI模式
    change_any_model_to_cli(ssh)
    return False, ret[1] + "\n" + temp


def change_cli2_developer_with_err_msg(ssh, py_java_env):
    """
            函数名称: changeCli2DeveloperWithErrMsg
            功能说明: 从CLI模式进入developer模式（需要确定使用之前为CLI模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False, ErrMsg
    """
    err_msg = ""
    lang = py_java_env.get("lang")
    dev_passwd = py_java_env.get("devPwd").get("developer")
    if not dev_passwd:
        if "zh" == lang:
            err_msg = u"\n获取调试密码为空，请确定是否已配置调试密码。"
        else:
            err_msg = "\nThe debug password is blank. Ple" \
                      "ase confirm that the debug password is set."
        return False, err_msg

    cli_ret = ssh.execCmd(CLI_CMD.SWITCH_TO_DEVELOPER)
    # 判断是否已经developer模式
    for i in range(3):  # 密码错误 时需要重试三次
        if re.search("Password", cli_ret, re.IGNORECASE):
            temp = ssh.execCmdNoLog(dev_passwd)
            if re.search("developer", temp, re.IGNORECASE):
                return True, err_msg

    if "zh" == lang:
        err_msg = u"\n切换到developer模式失败，可能的原因是：" \
                  u"当前用户不支持developer模式或调试密码输入错误。" \
                  u"请按照如下建议处理：\
        \n（1）如果当前用户级别不是超级管理员或者管理员，" \
                  u"请使用超级管理员或者管理员用户登录后重新执行巡检；\
        \n（2）如果当前用户级别是超级管理员或者管理员，" \
                  u"请检查调试密码是否正确输入，" \
                  u"输入正确的调试密码后重新执行巡检。"
    else:
        err_msg = u"\nFailed to switch to the developer mode. " \
                  u"The reason of failure may be: " \
                  u"Current user cannot switch to developer mode " \
                  u"or the debug password entered is incorrect.\
        \n(1) If the current user level is not Super_admin or Admin, " \
                  u"log in as Super_admin or " \
                  u"Admin and perform inspection again. \
        \n(2) If the current user level is Super_admin or Admin, " \
                  u"check whether the debug password is correct. " \
                  u"Enter the correct debug password " \
                  u"and perform inspection again."

    # 进入developer模式失败，重新回到CLI模式
    change_any_model_to_cli(ssh)
    return False, err_msg


def change_cli2_diagnose(ssh, dev_passwd, logger):
    """
            函数名称: changeCli2Diagnose
            功能说明: 从CLI模式进入diagnose模式（需要确定使用之前为CLI模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    """

    if not change_cli2_developer(ssh, dev_passwd, logger):
        return False

    dev_ret = ssh.execCmdWithTimout("debug", 10)
    if re.search('diagnose>', dev_ret, re.IGNORECASE):
        return True

    # 进入diagnose模式失败，重新回到CLI模式
    change_any_model_to_cli(ssh)
    return False


def change_cli2_diagnose_with_cli_ret(ssh, dev_passwd, logger):
    """
            函数名称: changeCli2Diagnose
            功能说明: 从CLI模式进入diagnose模式（需要确定使用之前为CLI模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    """
    flag, cli_ret = change_cli2_developer_with_cli_ret(ssh, dev_passwd,
                                                       logger)
    if not flag:
        return flag, cli_ret

    dev_ret = ssh.execCmdWithTimout("debug", 10)
    if re.search('diagnose>', dev_ret, re.IGNORECASE):
        return True, cli_ret + "\n" + dev_ret

    # 进入diagnose模式失败，重新回到CLI模式
    change_any_model_to_cli(ssh)
    return False, cli_ret + "\n" + dev_ret


def change_any_model_to_cli_with_log(ssh, logger):
    """
            函数名称: changeAnyModel2CliWithLog
            功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    """
    counter = 0

    try:
        while True:
            temp = ssh.execCmdWithTimout("show system general", 180)

            # 非developer模式下，cli回文正确，则认为回到了cli
            if (re.search("System Name", temp, re.IGNORECASE)
                    and not re.search("developer:", temp, re.IGNORECASE)):
                break

            # 最小系统下执行exitSPC200及其之前的版本断开连接；SPC300及其之后的版本退回到developer模式。
            if re.search("minisystem", temp, re.IGNORECASE):
                temp1 = ssh.execCmd("exit")
                if re.search("Are you sure", temp1, re.IGNORECASE):
                    try:
                        ssh.execCmd("y")
                    except Exception as e:
                        # SPC200及之前的版本可能断开连接或者网络异常。
                        logger.error(
                            'Exit from minisystem exception, the '
                            'SSH connection is disconnected, '
                            'reconnect now: ' + unicode(e))
                        ssh.reConnect()
            elif re.search("-bash", temp, re.IGNORECASE):  # os_only模式下直接退出
                ssh.execCmdWithTimout("sh /ISM/cli/start.sh", 60)
            else:  # 其他情况下，直接exit
                temp1 = ssh.execCmd("exit")
                if re.search("Are you sure", temp1, re.IGNORECASE):
                    ssh.execCmd("n")
                    break

            # 单控的命令模式最多4层
            counter += 1
            if counter >= 5:
                break
    except Exception as ex:
        logger.error('Exit to CLI mode failed:' + ex)
    else:
        logger.info('No exception caught when exiting to CLI mode')
    finally:
        model = getCtrlCmdMode(ssh, logger)
        logger.info("Change any mode to CLI mode result:" + unicode(model))

        return model


def change_any_model_to_cli(ssh):
    """
            函数名称: changeAnyModel2Cli
            功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    """
    counter = 0

    while True:
        temp = ssh.execCmdWithTimout("show system general", 180)

        # 非developer模式下，cli回文正确，则认为回到了cli
        if re.search("System Name", temp, re.IGNORECASE) \
                and not re.search("developer:", temp, re.IGNORECASE):
            break

        # 最小系统下要用exit会直接断开连接（也可能退出到admin模式，待确认）
        if re.search("minisystem", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                try:
                    ssh.execCmd("y")
                except Exception:
                    ssh.reConnect()
        # os_only模式下直接退出
        elif re.search("-bash", temp, re.IGNORECASE):
            ssh.execCmdWithTimout("sh /ISM/cli/start.sh", 60)

        # 其他情况下，直接exit
        else:
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                ssh.execCmd("n")
                break

        # 单控的命令模式最多4层
        counter += 1
        if counter >= 5:
            break


def change_developer_to_minisystem(ssh, py_java_env):
    """
            函数名称: changeDeveloper2Minisystem
            功能说明: 从developer模式进入minisystem模式（需要确定使用之前为developer模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    """
    java_env = py_java_env
    user_name = java_env.get("devInfo").getLoginUser().getUserName()
    if "admin" == user_name:
        temp = ssh.execCmdWithTimout("minisystem", 5)  # 进入minisystem
        if re.search("minisystem>", temp, re.IGNORECASE):
            return True

        if re.search("Are you sure", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("y")
            if re.search("minisystem>", temp1, re.IGNORECASE):
                return True

        return False
    else:
        return False


def change_climodel_to_minisystem(ssh, py_java_env, dev_passwd, logger):
    """
            函数名称: changeCliModel2Minisystem
            功能说明: 从CLI模式切换到minisystem模式
            输入参数: ssh, devPasswd, logger
            输出参数: 无
            返 回 值: True or False
    """

    if not change_cli2_developer(ssh, dev_passwd, logger):
        logger.error('Switch cli to developer mode failed!')
        change_any_model_to_cli(ssh)
        return False

    if not change_developer_to_minisystem(ssh, py_java_env):
        logger.error('Switch developer to minisystem mode failed!')
        change_any_model_to_cli(ssh)
        return False

    logger.info('Switch cli to minisystem mode successfully!')
    return True


def exit_from_peer_minisystem(ssh):
    """
            函数名称: exitFromPeerMinisystem
            功能说明: 从对端cli模式切换到本端minisystem模式
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    """
    count = 0
    while True:
        temp = ssh.execCmd("exit")
        if re.search("Are you sure to exit", temp, re.IGNORECASE):
            temp = ssh.execCmdWithTimout('y', 30)
        if re.search('closed', temp, re.IGNORECASE):
            return True
        count += 1
        if count > 4:
            break

    return False


def heart_beat_to_peer(ssh, usr_pwd, logger):
    """
            函数名称: heartbeatToPeer
            功能说明: 从本端minisystem模式心跳到对端，此方法须在minisystem模式下调用
            输入参数: ssh,usrPwd
            输出参数: 无
            返 回 值: True or False
    """
    try:
        temp = ssh.execCmd("sshtoremote")

        if (
                re.search(
                    'Are you sure you want to continue connecting (yes/no)?',
                    temp, re.IGNORECASE)):
            temp = ssh.execCmd("yes")

        if re.search("password:", temp, re.IGNORECASE):
            temp1 = ssh.execCmdNoLogTimout(usr_pwd, 60)
            logger.info("[temp1] CLI echo text:" + unicode(temp1))

            if TOOLKIT_SEND_CMD_TIME_OUT == temp1:
                logger.error("[heartbeatToPeer] execute cmd timeout.")
                change_any_model_to_cli_with_log(ssh, logger)
                return False

            if (re.search("You have accessed the system operated", temp1,
                          re.IGNORECASE)
                    and temp1.endswith('admin:/>')):
                return True

        logger.error("[heartbeatToPeer] heart to peer failed.")
        change_any_model_to_cli_with_log(ssh, logger)
        return False
    except Exception as e:
        logger.error("[heartbeatToPeer] catch Exception:" + unicode(e))
        change_any_model_to_cli_with_log(ssh, logger)
        return False
