# -*- coding: UTF-8 -*-
import traceback
import re

abnormalTag = ["The system failed to be started","Error: The system has an internal error",\
               "System is in safe mode","The system is powering off","The user is offline","Error: "]

#########################################
#      巡检前置脚本
# 巡检前检查设备是否正常，目前登录的用户模式
#########################################
PRODUCT_VESION = ["V200R002C10","V300R001C00"]

# **************************************************************************** #
# 函数名称: isChinese
# 功能说明: 判断当前语言是否为中文
# 输入参数: 无
# 输出参数: True or False
# **************************************************************************** # 
def isChinese():
    lang = py_java_env.get("lang")
    if "zh"==lang:
        return True
    return False

# **************************************************************************** #
# 函数名称: isStartOk
# 功能说明: 初步判断系统是否启动正常
# 输入参数: devObj
# 输出参数: True or False
# **************************************************************************** # 
def isStartOk(devObj):
    flag = True
    cliRet = ""
    ssh =  devObj.get("ssh")
    cliRet = ssh.execCmd("show system general")
    
    for strTag in abnormalTag:
        if re.search(strTag, cliRet, re.IGNORECASE):
            flag = False
            break
    return (flag, cliRet)
        
# **************************************************************************** #
# 函数名称: isNormalSystem
# 功能说明: 判断系统是否处于正常模式
# 输入参数: cliRet
# 输出参数: True or False
# **************************************************************************** # 
def isNormalSystem(cliRet):
    errMsg = ""
    
    #根据回显判断设备是否开工正常，Health Status及Running Status都要为Normal,版本号要正常
    healthStatus = ""
    runningStatus = ""
    productVersion = ""
    lineList = cliRet.splitlines()
    for line in lineList:
        line = line.replace(" ","")
        if line.startswith("HealthStatus:"):
            healthStatus = line.replace("HealthStatus:","")
        elif line.startswith("RunningStatus:"):
            runningStatus = line.replace("RunningStatus:","")
        elif line.startswith("ProductVersion:"):
            productVersion = line.replace("ProductVersion:","")
            break  
     
    #防止获取信息为空导致提示信息比较迷惑  
    if "" == healthStatus or "" == runningStatus or "" == productVersion:
        if isChinese():
            errMsg =u"\n系统状态不正常"
        else:     
            errMsg = "\nSystem is abnormal"
        return (False, errMsg)    
    
    if healthStatus not in ["normal", "Normal"]:
        if isChinese():
            errMsg =u"\n设备健康状态异常"+u"（"+healthStatus+u"）"
        else:     
            errMsg = "\nDevice health status is abnormal "+"("+healthStatus+")"
        return (False, errMsg)
    
    if runningStatus not in ["normal", "Normal"]:
        if isChinese():
            errMsg =u"\n设备运行状态异常"+u"（"+runningStatus+u"）"
        else:     
            errMsg = "\nDevice running status is abnormal "+"("+runningStatus+")"
        return (False, errMsg)
    
    if productVersion not in PRODUCT_VESION:  
        if isChinese():
            errMsg =u"\n设备产品版本异常"
        else:     
            errMsg = "\nDevice product version is abnormal"
        return (False, errMsg)
    
    return (True, errMsg)

#设置异常返回的提示信息，涉及到中英文

res_desc_zh = {'success': ur'系统检查通过', 
               'failed': ur'系统状态不正常', 
               'except':  ur'系统检查异常'
               }
                
res_desc_en = {'success': r'System check done',
               'failed':  r'System is abnormal',
               'except':  r'System check except'
               }
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

   
# **************************************************************************** #
# 函数名称: execute
# 功能说明: 执行巡检脚本之前判断，判断系统是否处于正常状态
# 输入参数: cliRet
# 输出参数: True or False
# **************************************************************************** # 
def execute(devObj):
    try:
        lang = ""
        if isChinese():
            lang = "zh"
        else:
            lang = "en"
    
        #初步判断系统是否启动成功
        isOk, cliRet = isStartOk(devObj)
        if not isOk:
            return ('', dict(flag = False, des = res_desc[lang]['failed']))
        
        #判断系统状态是否正常,带回具体失败原因
        isNormal, errMsg = isNormalSystem(cliRet)
        if isNormal:
            return ('', dict(flag = True, des = res_desc[lang]['success']))
        else:
            return ('', dict(flag = False, des = errMsg))
        
    except Exception, exception:
        PY_LOGGER.error("Preinpect catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Preinpect catch except of messages:" + str(exception))
        PY_LOGGER.error("Preinpect catch except of trace back:" + str(traceback.print_exc()))
        return ('', dict(flag = False, des = res_desc[lang]['except']))
