# -*- coding: UTF-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32, UnsignedInt8, UnsignedInt16
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from java.lang import Exception



#查询NAS引擎信息TLV命令字
INTEGRATIVE_QUERY = 55847747703

# 命令执行超时时间
CMD_DEFAULT_TIMEOUT = 60

#support index
SUPPORT_INDEX = 3

def execute(tlvConnection):
    '''
    @summary: 获取登陆NAS引擎的基本信息
    @param tlvConnection: TLV连接
    @return xmlStringResult：将NAS引擎信息以框架需要的XML格式返回
    '''
    flag = True
    ip = ""
    user = ""
    pasword = ""
    try:
        recs = tlvConnection.getBatch(INTEGRATIVE_QUERY, TLVUtils.paramList(), CMD_DEFAULT_TIMEOUT)
        itemNum = recs.size()
        #获取NAS引擎的信息组合成XML格式反馈给工具框架
        for index in range(0, itemNum):
            if (index == SUPPORT_INDEX):
                rec = recs.get(index)
                ip = rec.getParamStrValue(0)
                user = rec.getParamStrValue(2)
                pasword = rec.getParamStrValue(3)
                xmlStringResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\<devices><device><ip>ipaddr</ip><username>usrname</username><password>usrpswd</password></device></devices>"
        xmlStringResult = xmlStringResult.replace("ipaddr", ip)
        xmlStringResult = xmlStringResult.replace("usrname", user)
        xmlStringResult = xmlStringResult.replace("usrpswd", pasword)
        del pasword
    except:
        xmlStringResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><devices></devices>"
        flag = False
    
    return (flag, xmlStringResult)
