# -*- coding: UTF-8 -*-

import copy

import common
import cliUtil
from container_base_check import ContainerCheck

PY_JAVA_ENV = py_java_env
LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = common.getLang(PY_JAVA_ENV)

CHECK_URL_LIST = ["infra/inspect/service/backupbusinessstatus"]


def execute(cli):
    """
    备份业务状态检查，详情需分析原始信息
    :param cli:
    :return:
    """
    if not common.has_data_backup_and_support_data_protect(PY_JAVA_ENV, cli):
        return cliUtil.RESULT_NOSUPPORT, "", ""

    dev_node = PY_JAVA_ENV.get("devInfo")
    flag, ips_dict = common.is_need_change_devnode_ip(cli, LOGGER, LANG)
    if flag:
        temp_dev_node = copy.deepcopy(dev_node)
        temp_dev_node.setIp(ips_dict.get("0")[0])
        flag, item_check, msg = _container_check(temp_dev_node)
        return flag, "\n".join(item_check.all_cli_ret), msg
    flag, item_check, msg = _container_check(dev_node)
    return flag, "\n".join(item_check.all_cli_ret), msg


def _container_check(dev_node):
    item_check = ContainerCheck(dev_node, CHECK_URL_LIST, LANG, LOGGER)
    flag, msg = item_check.execute_check()
    return flag, item_check, msg
