# -*- coding: UTF-8 -*-
import cliUtil
import common
import expandconfig
from config import DiskType
import expTask

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)
expConfigObj = expandconfig.ExpandConfig(py_java_env)

VERSION_WHILE_VER = "V300R001C10"

#进度总剩余时间
LIMIT_TIME = 120
#进度刷新间隔
INTERVAL = 2

def execute(cli):
    '''
        硬盘容量截断检查
    '''
    flag = True
    cliRetAll = ""
    errMsg = ""
    try:
        
                #进度条刷新
        common.threadUpProcess(py_java_env, LIMIT_TIME, INTERVAL, logger)
        #进度开始
        common.inProcess(py_java_env)
        logger.logInfo("process Thread started!")
        
        flag, cliRet, errMsg = checkVersion(cli, logger, lang)
        if flag != True:
            return flag, cliRet, errMsg

        cliRetAll += cliRet
        expDiskInfoDict = expConfigObj.getExpDiskInfo()
        expDiskList = common.getExpDiskList(expDiskInfoDict)
        # 遍历扩容硬盘域
        for expDisks in expDiskList:
            checkTask = expTask.ExpTask(py_java_env, cli, expDisks, logger)
            checkTask.checkNlSas()
            result, msg, cliRet = checkTask.getResult()
            cliRetAll += cliRet
            if result != True:
                errMsg += msg
                flag = result if flag and result else False

        return flag, cliRetAll, errMsg
    except Exception, exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(lang,"query.result.abnormal")
    finally:
        common.finishProcess(py_java_env)
        logger.logInfo("finish process!")

def checkVersion(cli, logger, lang):
    flag, sys, patch, cliRet, errMsg = common.getProductVersionAndHotPatchVersion(cli, logger, lang)
    if flag != True:
        return flag, cliRet, errMsg

    if VERSION_WHILE_VER not in sys:
        return cliUtil.RESULT_NOSUPPORT, cliRet, ""

    return True, cliRet, errMsg
