# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import common
import cliUtil
from cbb.business.operate.checkitems.check_scan_status import CheckScanStatus
from cbb.frame.base import baseUtil
from cbb.frame.base.constants import CheckStatus

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    """检查系统扫描状态

    :param cli:
    :return:
    """
    try:
        check = CheckScanStatus(LANG, cli, LOGGER)
        result_flag, cli_ret, err_msg = check.run()
        # 检查通过
        if result_flag == CheckStatus.PASS:
            return True, cli_ret, err_msg
        # 检查不通过
        elif result_flag == CheckStatus.NOTPASS:
            return False, cli_ret, err_msg
        # 未完成检查
        return cliUtil.RESULT_NOCHECK, cli_ret, err_msg
    except Exception as ex:
        LOGGER.logException(ex)
        err_msg = baseUtil.getPyResource(LANG, "query.result.abnormal")
        return cliUtil.RESULT_NOCHECK, "", err_msg
