# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        辅助风扇状态检查: 
                 如果能查询到辅助散热模块信息，并且辅助散热模块的健康状态或运行状态不正常属于不正常；
                其他情况属于正常；
   '''
    flag = True
    cliRet = ""
    cliRetAll = ""
    errMsg = ""

    try:
        cmd = "show assistant_cooling_unit"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        
        #get result of the command which has been executed.
        cliRetAll += checkRet[1]
        if checkRet[0] != True:
            errMsg += checkRet[2]
            LOGGER.logSysAbnormal()
            return (checkRet[0], cliRetAll, errMsg)
        
        #get information of auxiliary fans.
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        #res pass if no auxiliary fan exist.
        if cliUtil.queryResultWithNoRecord(cliRet):
            LOGGER.logPass()
            return (True, cliRet, errMsg)
        else:
            #check health status and running status of auxiliary fan one by one.
            #it's not pass either health status or running status is abnormal.
            for line in cliRetLinesList:
                fanID = line.get("ID")
                healthStatus = line.get("Health Status")
                runningStatus = line.get("Running Status")
                
                if healthStatus != common.STATUS_NORMAL:
                    flag = False
                    errMsg += common.getMsg(LANG, "auxiliary.fan.health.status.abnormal", (fanID, healthStatus))
                    LOGGER.logNoPass("The Health Status of auxiliary  fan [%s] is abnormal (Health Status:%s)" % 
                        (fanID, healthStatus))
                
                if runningStatus != common.STATUS_ONLINE:
                    flag = False
                    errMsg += common.getMsg(LANG, "auxiliary.fan.running.status.abnormal", (fanID, runningStatus))
                    LOGGER.logNoPass("The Running Status of auxiliary fan [%s] is abnormal (Running Status:%s)" % 
                        (fanID, runningStatus))
            return (flag, cliRetAll, errMsg)
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
