# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        级联口误码检查：
                如果SAS端口存在持续增加的误码表示不正常，其它情况均属于正常状态。
    '''
    cliRet = ""
    ports = ["SAS"]
    
    try:
        cmd = "show port bit_error"
        LOGGER.logExecCmd(cmd)
        checkPortsBitErrorRet = common.checkPortsBitError(cli, cmd, ports, LANG, py_java_env, LOGGER)
        cliRet = checkPortsBitErrorRet[1]
        if checkPortsBitErrorRet[0] != True:
            LOGGER.logNoPass("SAS ports has continuous bit errors:\n" + cliRet)
        else:
            LOGGER.logPass()
        return checkPortsBitErrorRet

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
