# -*- coding: UTF-8 -*-
import cliUtil
from cli_util_cache import get_disk_with_filter_cache
import common
import config_1
from common import UnCheckException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env


def execute(cli):
    """
    检查项名称(中文)	硬盘切片大小检测
     检查方法
    1、以admin用户登录设备；
    2、执行命令：show disk general |filterColumn include columnList=ID,
    Manufacturer,Model,Firmware\\sVersion,Bar\\sCode，查询硬盘型号；
    3、执行命令：show upgrade package，获取设备软件版本和补丁版本。
    检查方法(英文)
    检查标准
    1、如果步骤2中存在如下Model的硬盘，则继续检查，否则检查通过。
        HUC109030CSS600,HUC109060CSS600,HUC109090CSS600,
        HUS726020ALS210,HUS726030ALS210,
        HUS726040AL4215,HUS726040ALS210,HUS726060AL4210,
        HUS726060AL4215,HUS726060AL5210,
        HUS724020ALS640,HUS724030ALS640,HUS724040ALS640；
    2、如果步骤3中软件版本是V300R006C20/V500R007C10，
    且补丁版本小于V300R006C20SPH015/V500R007C10SPH015则检查结果为建议优化；
       如果步骤3中软件版本是V300R006C50SPC100/V500R007C30SPC100，
       且补丁版本小于V300R006C50SPH105/V500R007C30SPH105则
       检查结果为建议优化；
       其他版本则检查通过。
    检查标准(英文)
    修复建议
    如果检查结果为建议优化，请安装如下或更高版本补丁，
    有疑问请联系技术支持工程师。
    V300R006C20/V500R007C10：V300R006C20SPH015/V500R007C10SPH015
    V300R006C50SPC100/V500R007C30SPC100：V300R006C50SPH105/V500R007C30SPH105
    """

    all_cli_ret = ''
    try:

        # 如果步骤2中存在如下Model的硬盘，则继续检查，否则检查通过
        disk_info_list, cli_ret = get_disk_with_filter_cache(PY_JAVA_ENV, cli,
                                                             LOGGER)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        risk_disk_list = []
        for disk_info in disk_info_list:
            disk_model = disk_info.get("Model")
            if disk_model in config_1.RISK_DISK_BURST_SIZE_MODEL:
                risk_disk_list.append(disk_model)

        risk_disk_list = list(set(risk_disk_list))
        if not risk_disk_list:
            return True, all_cli_ret, ''

        (flag, p_version, p_patch, cli_ret,
         err_msg) = common.getProductVersionAndHotPatchVersion(cli,
                                                               LOGGER,
                                                               LANG)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, all_cli_ret, err_msg

        if p_version not in config_1.RISK_DISK_BURST_PRODUCT_VERSION:
            return True, all_cli_ret, ''

        exp_patch = config_1.RISK_DISK_BURST_PRODUCT_VERSION.get(p_version)
        if p_patch < exp_patch:
            err_msg = common.getMsg(LANG, "risk.disk.burst.suggestion", (
                ",".join(risk_disk_list),
                p_version, p_patch))
            return cliUtil.RESULT_WARNING, all_cli_ret, err_msg

        # 检查通过
        return True, all_cli_ret, ''
    except UnCheckException as un_check_exp:
        return (un_check_exp.flag, un_check_exp.cliRet,
                un_check_exp.errorMsg)

    except Exception as e:
        LOGGER.logError(str(e))
        return (cliUtil.RESULT_NOCHECK, all_cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))
