# -*- coding: UTF-8 -*-
import cliUtil
import common

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)
from config import DiskType

def execute(cli):
    '''
        扩容硬盘容量规格检查
    '''
    cliRetAll = ""
    versionList = ["V300R001C00", "V300R001C00SPC100"]
    expDiskList = common.getExpDiskListFromContextFilter(py_java_env)
    logger.logInfo("expDiskList is %s" % expDiskList)
    
    try:
        # 如果都是新建硬盘域,则不涉及
        if not expDiskList:
            return cliUtil.RESULT_NOSUPPORT, "", ""
        
        ret, sysVersionList, hotpatchVersionList = common.parse_upgradePackage(cli, lang)
        cliRet = ret[1]
        if not ret[0]:
            return cliUtil.RESULT_NOCHECK, cliRet, ret[2]

        # 非系统版本:"V300R001C00", "V300R001C00SPC100" 不涉及此检查项
        ret, sysVersion, errInfo = common.getCurrentVersion(sysVersionList,lang)
        logger.logInfo("current system version:%s" % (sysVersion))
        if not ret:
            errMsg = errInfo
            return cliUtil.RESULT_NOCHECK, cliRet, errMsg
        if sysVersion not in versionList:
            logger.logInfo("the current system version is not mentioned")
            return cliUtil.RESULT_NOSUPPORT, cliRet, ""

        cliRetAll += cliRet
        # 获取硬盘域信息
        flag, cliRet, errMsg, diskDomainList = common.getDiskDomainInfo(cli, lang)
        cliRetAll += cliRet
        if not flag:
            logger.logSysAbnormal()
            return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg

        # 硬盘域不存在返回不涉及
        if flag and not diskDomainList:
            logger.logInfo("the disk domain is not exist")
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, ""
        logger.logInfo("diskDomainList is %s" % diskDomainList)

        for diskDomain in diskDomainList:
            diskDomainId = diskDomain.get("ID")
            flag, cliRet, errMsg, diskInDomainList = common.getDiskDomainInfoById(cli, diskDomainId, lang)
            cliRetAll += cliRet
            if not flag:
                return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg

            # 获取硬盘域中的硬盘类型
            diskTypeList = [disk.get("Type") for disk in diskInDomainList]
            logger.logInfo("diskTypeList is %s" % diskTypeList)

            # 根据硬盘域ID获取对应的新扩硬盘类型
            newExpDiskList = filter(lambda disk:disk.get("diskDomain") == diskDomainId, expDiskList)
            logger.logInfo("newExpDiskList is %s" % newExpDiskList)

            newDiskModelList = [disk.get("diskModel") for disk in newExpDiskList]
            logger.logInfo("diskModelList is %s" % newDiskModelList)
            
            if len(set(newDiskModelList)) == 1 and DiskType.SSD not in newDiskModelList:
                flag = False
                logger.logNoPass("The type of new expand disk exist none-ssd disk")
                errMsg += common.getMsg(lang, "expand.disk.type.not.pass")
                continue

            # 获取新扩容硬盘容量
            newDiskCapacityList = []
            for line in newExpDiskList:
                diskCapacity = str(line.get("diskCapacity"))
                capacityUnit = str(line.get("unit"))
                diskCapacityGB = common.changUnit2GB(diskCapacity + capacityUnit, isLabelCap=True)
                newDiskCapacityList.append(diskCapacityGB[1])
            logger.logInfo("newDiskCapacityList is %s" % newDiskCapacityList)

            diskCapacityList = []
            for disk in diskInDomainList:
                diskId = disk.get("ID")  # 获取硬盘域中的硬盘ID
                isQrySucc, gbCap , errInfo= common.getDiskCapacityByDiskId(cli, diskId, lang,isHasLog=False)
                if not isQrySucc:
                    flag = False
                    errMsg += errInfo
                    continue
                diskCapacityList.append(gbCap)

            logger.logInfo("diskCapacityList is %s" % diskCapacityList)
            if not flag:
                return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg

            newAndOldDiskCapList = newDiskCapacityList + diskCapacityList
            newAndOldDiskCapListBase50GB = common.getDiskCapListBaseOn50GBDiff(newAndOldDiskCapList)
            logger.logInfo("newAndOldDiskCapList is %s" % newAndOldDiskCapList)
            logger.logInfo("newAndOldDiskCapListBase50GB is %s" % newAndOldDiskCapListBase50GB)

            # 新扩容的硬盘容量不等于原硬盘域中硬盘容量,检查不通过。
            if len(set(newAndOldDiskCapListBase50GB)) != 1:
                flag = False
                logger.logNoPass("The capacity disk is not equal to the new disk capacity")
                errMsg += common.getMsg(lang, "expand.disk.capacity.scale3.not.pass",
                                        (newDiskCapacityList[0], diskCapacityList[0]))
                continue

        return flag, cliRetAll, errMsg

    except Exception, exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(lang,"query.result.abnormal")