# -*- coding: UTF-8 -*-
import cliUtil
import common

NEED_RETRY = False
RETRIED = False
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    IB端口检查：
        1、如果IB端口不存在表示正常；
        2、Health Status状态不为Normal表示不正常；
        3、如果端口Health Status为Normal，Running Status为Link Up，Working Rate为56000Mbps或40000Mbps时则正常，否则不正常。
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    portName = "IB"
    
    try:
        cmd = "show ib_port general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        for line in cliRetLinesList:
            portId = line.get("ID")
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            workingRate = line.get("Working Rate(Mbps)")
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "port.health.status.abnormal", (portName, portId, healthStatus))
                LOGGER.logNoPass("The Health Status of IB port [%s] is abnormal (Health Status:%s)" % 
                    (portId, healthStatus))
            
            if runningStatus == common.STATUS_LINK_UP:
                if workingRate == "--":
                    flag = False
                    errMsg += common.getMsg(LANG, "cannot.get.port.working.rate", (portName, portId))
                    LOGGER.logNoPass("Cannot get working rate of %s port [%s]" % (portName, portId))
                elif workingRate not in ["40000", "56000"]:
                    flag = False
                    errMsg += common.getMsg(LANG, "port.working.rate.abnormal", (portName, portId, workingRate))
                    LOGGER.logNoPass("The working rate of IB port [%s] is abnormal (Working Rate:%sMbps)" % 
                        (portId, workingRate))
        
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
