# -*- coding: UTF-8 -*-
import cliUtil
import common
from cli_util_cache import is_upgrading

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
MIN_VER_C70 = 'V500R007C70'
MIN_VER_V6 = '6.0.0'


def execute(cli):
    """
        管理网口连接状态检查：
        1 ETH port中type为Management Port的Health Status必须为Normal。
                        端口Running Status为Link Up且工作速率为100Mbps或1000Mbps时表示正常；
        2 其它情况均属于不正常状态。
    """
    cli_ret_all = ''
    try:
        cmd = "show port general physical_type=ETH logic_type=Management_Port"
        LOGGER.logExecCmd(cmd)
        flag, ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cli_ret_all = common.joinLines(cli_ret_all, ret)
        if flag is not True:
            LOGGER.logSysAbnormal()
            return flag, cli_ret_all, err_msg
        cli_ret_lines_list = cliUtil.getHorizontalCliRet(ret)
        if not cli_ret_lines_list:
            err_msg = common.getMsg(LANG, "cannot.get.management.port.info")
            LOGGER.logNoPass("Cannot get information about Management Port")
            return (False, cli_ret_all, err_msg)

        err_msg, flag = check_magt_port_status(cli_ret_lines_list)
        if flag:
            LOGGER.logPass()
            return flag, cli_ret_all, ''
        # dorado v6 大于 6.0.0的
        # 融合存储V5R7C70开始支持查询后台升级任务的命令
        up_flag, cli_ret = is_upgrading(cli, LANG)
        LOGGER.logInfo("isUpgrading:{up_flag}".format(up_flag=up_flag))
        if up_flag:
            cli_ret_all = common.joinLines(cli_ret_all, cli_ret)
            key = "firmware.version.of.manager.upgrading"
            return (cliUtil.RESULT_NOCHECK, cli_ret_all,
                    common.getMsg(LANG, key))

        return flag, cli_ret_all, err_msg
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cli_ret_all,
                common.getMsg(LANG, "query.result.abnormal"))


def check_magt_port_status(cli_ret_lines_list):
    err_msg = ""
    flag = True
    for record in cli_ret_lines_list:
        port_id = record.get("ID")
        health_status = record.get("Health Status")
        running_status = record.get("Running Status")
        working_rate = record.get("Working Rate(Mbps)")
        if health_status != common.STATUS_NORMAL:
            flag = False
            key = "management.port.health.status.abnormal"
            err_msg += common.getMsg(LANG, key, (port_id, health_status))
            LOGGER.logNoPass("[%s] is abnormal (Health Status:%s)"
                             % (port_id, health_status))

        if running_status == common.STATUS_LINK_UP and working_rate not in ["100", "1000"]:
            flag = False
            key = "management.port.working.rate.abnormal"
            err_msg += common.getMsg(LANG, key, (port_id, working_rate))
            LOGGER.logNoPass("[%s] is abnormal (Working Rate:%sMbps)"
                             % (port_id, working_rate))
    return err_msg, flag
