# -*- coding: UTF-8 -*-
import cliUtil
import common
import common_utils
import common_cache
import traceback
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
ALL_CLI_RET_LIST = []


def execute(cli):
    '''
        双活两端的lun配置一致性检查：
        1、    若不存在双活pair，则检查结果为通过。
        2、    若步骤4与步骤6中的“Work Controller”值不一致，则检查结果为不通过。
        3、    若步骤4与步骤6中的“Disk Location”值都为“External”且存在厂商信息不为华为存储，则检查结果为不通过，其他情况检查结果为通过。
    '''
    global ALL_CLI_RET_LIST
    flag = True
    cliRet = ""
    allCliRet = ""
    errMsg = ""
    item = "hypermetro_lun_configuration"
    try:
        
        #本端SN
        locaDevSn = PY_JAVA_ENV.get("devInfo").getDeviceSerialNumber()
        flag, ret, msg, pair_list = common_cache.get_san_pair_from_cache(
            py_java_env, LOGGER, locaDevSn, LANG)
        ALL_CLI_RET_LIST.append(ret)
        if flag is not True:
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        if cliUtil.queryResultWithNoRecord(ret):
            return (True, cliRet, errMsg)
        
        #1、框架未获取到双活远端设备；2、存在远端设备且未添加
        flag, addedSnList, errMsg = common.checkAddedRemoteDevSn(PY_JAVA_ENV, LANG)
        if flag != True:
            return common_utils.get_result_bureau(PY_JAVA_ENV, allCliRet, errMsg)
        
        #无双活
        if not addedSnList:
            return (True, allCliRet, errMsg)
        
        pairLunIdDict = getLunInfoByPair(pair_list)
        LOGGER.logInfo("pairLunIdDict ={}".format(str(pairLunIdDict)))
        #获取本端双活LUN信息
        flag, cliRet, errMsg, locaWorkContInfoDict, locaVenDorDict = \
        gethyperMetroPairInfo(pairLunIdDict, "Local ID", locaDevSn)
        LOGGER.logInfo("locaWorkContInfoDict = %s" % str(locaWorkContInfoDict))
        LOGGER.logInfo("locaVenDorDict = %s" % str(locaVenDorDict))
        ALL_CLI_RET_LIST.append("ON LOCAL DEVICE(SN:%s):" % locaDevSn)
        ALL_CLI_RET_LIST.append(cliRet)
        
        if flag != True: 
            return (cliUtil.RESULT_NOCHECK, "\n".join(ALL_CLI_RET_LIST),
                    errMsg)
            
        #获取双活对端的SN列表
        flag, cliRet, errMsg, hyperRemoteSnList = common.getRemoteDevSn(py_java_env, locaDevSn, LOGGER, LANG)
        ALL_CLI_RET_LIST.append(cliRet)
        if flag != True:
            return common_utils.get_result_bureau(PY_JAVA_ENV, "\n".join(ALL_CLI_RET_LIST), errMsg)
        LOGGER.logInfo("hyperRemoteSnList = %s" % str(hyperRemoteSnList))
        
        flagList = []
        #获取远端LUN双活信息
        for remoteSn in hyperRemoteSnList:
            #添加部分双活设备
            if remoteSn not in addedSnList:
                flag = cliUtil.RESULT_NOCHECK
                flagList.append(flag)
                errMsg += common.getMsg(LANG, "not.add.remote.device", remoteSn)
                continue
            
            flag, cliRet, msg, remoteWorkContInfoDict, remoteVenDorDict = \
            gethyperMetroPairInfo(pairLunIdDict, "Remote ID", remoteSn, locaDevSn)
            LOGGER.logInfo("remoteWorkContInfoDict = %s" % str(remoteWorkContInfoDict))
            LOGGER.logInfo("remoteVenDorList = %s" % str(remoteVenDorDict))
            ALL_CLI_RET_LIST.append("ON REMOTE DEVICE(SN:%s):" % remoteSn)
            ALL_CLI_RET_LIST.append(cliRet)
            if flag is not True:
                cli_ret = common_cache.save_cli_ret_to_file(
                    ALL_CLI_RET_LIST,
                    item,
                    PY_JAVA_ENV, LOGGER)
                flagList.append(cliUtil.RESULT_NOCHECK)
                return (cliUtil.RESULT_NOCHECK, cli_ret, msg)
            
            result, errInfo = isHuaWeiVendor(locaVenDorDict, remoteVenDorDict)
            if not result:
                flag = cliUtil.RESULT_WARNING
                flagList.append(flag)
                errMsg += errInfo
                
            #判断双活LUN的归属控制器是否一致
            workFlag, errInfo = \
            checkPairWorkContr(locaWorkContInfoDict, remoteWorkContInfoDict)
            if not workFlag:
                flag = cliUtil.RESULT_WARNING
                flagList.append(flag)
                errMsg += errInfo

        cli_ret = common_cache.save_cli_ret_to_file(ALL_CLI_RET_LIST,
                                                    item,
                                                    PY_JAVA_ENV, LOGGER)
        flagList = list(set(flagList))
        if cliUtil.RESULT_WARNING in flagList:
            sugg_msg = common.getMsg(LANG, "lun.cfg.inconsistency.sugg")
            return (cliUtil.RESULT_WARNING, cli_ret, errMsg + sugg_msg)
        
        if cliUtil.RESULT_NOCHECK in flagList:
            return common_utils.get_result_bureau(PY_JAVA_ENV, cli_ret, errMsg)
        
        return (True, cli_ret, errMsg)
   
            
    except Exception:
        LOGGER.logError(str(traceback.format_exc()))
        cli_ret = common_cache.save_cli_ret_to_file(ALL_CLI_RET_LIST,
                                                    item,
                                                    PY_JAVA_ENV, LOGGER)
        return (cliUtil.RESULT_NOCHECK, cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))


def getLunInfoByPair(pair_info_list):
    """
    @summary: 获取双活Pair与对应LUN的关系字典
    """
    pairLunIdDict = {}
    for pair_info in pair_info_list:
        pair_id = pair_info.get("ID")
        pairLunIdDict[pair_id] = pair_info

    return pairLunIdDict


def checkPairWorkContr(locaWorkContInfoDict, remoteWorkContInfoDict):
    """
    @summary: 检查双活Pair的归属控制器是否相同
    """
    flag = True
    errMsg = ""
    for pairId in remoteWorkContInfoDict:
        locaWorkCont = locaWorkContInfoDict[pairId]
        remoteWorkCont = remoteWorkContInfoDict[pairId]
        if locaWorkCont != remoteWorkCont:
            flag = False
            errMsg += common.getMsg(LANG, "pair.inconsistent.work.controllers", pairId)
            
    return (flag, errMsg) 

def isHuaWeiVendor(locaVenDorDict, remoteVenDorDict):
    """
    @summary: 判断是否存在异构LUN且为非华为厂商设备
    """
    flag = True 
    errMsg = ""
    if (not locaVenDorDict) or (not remoteVenDorDict):
        return (flag, errMsg)
    
    for pairId in locaVenDorDict:
        localVendor = locaVenDorDict[pairId]
        for pairIdOther in remoteVenDorDict:
            remoteVendor = locaVenDorDict[pairIdOther]
            #同一pair下面存在非华为存储设备
            if pairId == pairIdOther and (localVendor.upper() != "HUAWEI" or remoteVendor.upper() != "HUAWEI"):
                flag = False
                errMsg += common.getMsg(LANG, "exist.Non-Huawei.vendor", pairId)
          
    return (flag, errMsg)


def gethyperMetroPairInfo(pairLunIdDict, lunIdFlag, SN, locaDevSn = None):
    """
    @summary: 获取双活两端LUN的详细信息
    @param cli: cli对象
    @param LANG: 语言LANG
    @param pairLunIdDict: 双活两端LUN的ID和Pair关系字典：{pairId:{"Local ID":localID,"Remote ID":remoteId}}
    @return: (falg, productModel, ret, errMsg)
    """
    allCliRet = ""
    workContInfoDict = {}
    pairVenDorinfoDict = {}
    hyperMetroPairId2Sndict = {}
    
    if locaDevSn:
        flag, hyperMetroPairId2Sndict, msg = common_cache.get_pair_to_dev_sn(
            py_java_env, locaDevSn, LOGGER, LANG)
        if flag is not True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, msg,
                    workContInfoDict, pairVenDorinfoDict)
        
    #获取双活两端LUN的工作控制器信息
    for pairId in pairLunIdDict:
        if (SN != hyperMetroPairId2Sndict.get(pairId)) and (lunIdFlag == "Remote ID") and locaDevSn:
            #匹配双活pair是否和Remote ID是否合规
            continue
                
        id = pairLunIdDict[pairId].get(lunIdFlag, "")
        cmd = "show lun general lun_id=%s" % id
        flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, SN, cmd, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True: 
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg, workContInfoDict, pairVenDorinfoDict)
        
        lunInfoDictList = cliUtil.getVerticalCliRet(cliRet)
        LOGGER.logInfo("lunInfoDictList = %s" % str(lunInfoDictList))
        for lunInfo in lunInfoDictList:
            diskLocl = lunInfo.get("Disk Location", "")
            workCont = lunInfo.get("Owner Controller", "")
            workContInfoDict[pairId] = workCont
            
            if diskLocl != "External":
                continue
            
            remoteLunWwn = lunInfo.get("Remote LUN WWN", "")
            LOGGER.logInfo("remoteLunWwn = %s" % str(remoteLunWwn))
            cmd = "show remote_lun general array_type=heterogeneity remote_lun_wwn=%s" % remoteLunWwn
            flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, SN, cmd, LANG)
            allCliRet = common.joinLines(allCliRet, cliRet)
            if flag != True: 
                return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg, workContInfoDict, pairVenDorinfoDict)
            
            remoteLunWwnDictList = cliUtil.getVerticalCliRet(cliRet)
            for remoteLunWwnDict in remoteLunWwnDictList:
                vendor = remoteLunWwnDict.get("Vendor", "")
                pairVenDorinfoDict[pairId] = vendor
            
    return (flag, allCliRet, errMsg, workContInfoDict, pairVenDorinfoDict)  

    
    
