# -*- coding: UTF-8 -*-
import cliUtil
import common
import hardware

from cbb.frame.cli import cliUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


PRODUCT_MODEL_H = [
    "OceanStor Dorado 8000 V6", "OceanStor Dorado 18000 V6", "OceanStor Dorado 6800 V6",
    "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800 V6", "OceanStor Dorado 18800K V6",
    "OceanStor 6810", "OceanStor 18510", "OceanStor 18500K", "OceanStor 18810",
    "6800 V5", "6800F V5", "6800K V5", "6810 V5", "6810F V5", "18500 V5", "18500F V5", "18500K V5",
    "18510 V5", "18510F V5", "18800 V5", "18800F V5", "18800K V5", "18810 V5", "18810F V5",
]


def execute(cli):
    '''
        AC2000W风险电源检查
        电源BOM为02312HGY或02352TYV，且电源型号为PAC2000S12-BG，电源固件版本为111、113、115、119
    '''
    all_cli_ret = []
    err_msg_list = []

    dev_type = str(py_java_env.get("devInfo").getDeviceType())

    _, product_ver, patch_ver, cli_ret = cliUtil.get_system_version_with_ret(cli, LANG)
    all_cli_ret.append(cli_ret)
    LOGGER.logNoPass("Product Model:{}. ".format(dev_type))
    LOGGER.logNoPass("Software Version:{}, Hotpatch Version:{}.".format(product_ver, patch_ver))
    if product_ver not in ['V500R007C60SPC100']:
        return True, "\n".join(all_cli_ret), ""
    if patch_ver >= "V500R007C60SPH111":
        return True, "\n".join(all_cli_ret), ""
    
    cli_cmd = "show power_supply|filterColumn include columnList=ID,Version,Model,Serial\sNumber"
    _, cli_ret, _ = cliUtil.execCmdInCliMode(cli, cli_cmd, True, LANG)
    psu_list = cliUtil.getHorizontalCliRet(cli_ret)
    all_cli_ret.append(cli_ret)
    psu_risk_msg = ""
    psu_warn_msg = ""
    for psu_info in psu_list:
        psu_id = psu_info.get("ID", "")
        psu_model = psu_info.get("Model", "")
        psu_verdc = psu_info.get("Version", "")
        psu_sn_code = psu_info.get("Serial Number", "")
        psu_bom, psu_date = psu_sn_code[2:10], psu_sn_code[12:14]
        if "CTE" in psu_id and dev_type in PRODUCT_MODEL_H: # 高端控制框PSU不识别风险电源
            continue
        psu_msg = "ID:{}, Model:{}, Version:{}, Serial Number: {}\n".format(psu_id, psu_model, psu_verdc, psu_sn_code)
        if psu_model == "PAC2000S12-BG" and psu_bom in ['02312HGY', '02352TYV']:
            if psu_date <= 'N3':
                psu_risk_msg += psu_msg
            else:
                psu_warn_msg += psu_msg
    
    if psu_risk_msg != "":
        err_msg_list.append(common.getMsg(LANG, "power.supply.2000w.risk"))
        err_msg_list.append(psu_risk_msg)
    if psu_warn_msg != "":
        err_msg_list.append(common.getMsg(LANG, "power.supply.2000w.warn"))
        err_msg_list.append(psu_warn_msg)
    if psu_risk_msg != "":
        return False, "\n".join(all_cli_ret), "\n".join(err_msg_list)
    elif psu_warn_msg != "":
        return cliUtil.RESULT_WARNING, "\n".join(all_cli_ret), "\n".join(err_msg_list)
    return True, "\n".join(all_cli_ret), ""

