# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):    
    '''
    @summary: 检查NAS双活结果是否通过
    @param cli: cli对象
    @return: （executeFlag, allCliRet, errMsg）    
        executeFlag：返回巡检结果     
            cliUtil.RESULT_NOSUPPORT：不支持
            cliUtil.RESULT_NOCHECK：未检查     
            True:  巡检结果为成功
            False: 巡检结果为失败
        allCliRet：返回CLI命令的所有回显
    '''  
    allCliRet = ""
    try:
        #检查版本是否支持
        isSucc, cliRet, errMsg = isProductModelAndVersionSupport(cli, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if isSucc == False:
            return (True, allCliRet, errMsg)

        if isSucc != True:
            return (isSucc, allCliRet, errMsg)
                
        #获取pair id并返回
        executeFlag, pairIDList, cliRet, errMsg = isExistHyperMetroVstorePair(cli)        

        allCliRet = common.joinLines(allCliRet, cliRet)
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, allCliRet, errMsg)

        if executeFlag != True:
            return (executeFlag, allCliRet, errMsg)

        #检查租户配置及健康状态          
        executeFlag, cliRet, errMsg = checkHyperMetroVstorePairStatus(cli, pairIDList)           
        allCliRet = common.joinLines(allCliRet, cliRet)
        return (executeFlag, allCliRet, errMsg) 
                      
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
    
def isExistHyperMetroVstorePair(cli):
    
    '''
    @summary: 检查pair_id是否为空
    @param cli: cli对象
    @return: （ executeFlag,pairIDList, cliRet, errMsg）    
        executeFlag：返回巡检结果     
            cliUtil.RESULT_NOSUPPORT：不支持
            cliUtil.RESULT_NOCHECK：未检查     
            True:  巡检结果为成功
            False: 巡检结果为失败
        pairIDList:返回不通过的pair id列表
        cliRet：返回CLI命令的所有回显
        errMsg：包含失败状态的错误信息       
    ''' 
    cmd = "show hyper_metro_vstore_pair general"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    pairIDList = []    
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, pairIDList, cliRet, errMsg) 
    
    if flag == False: 
        errMsg = common.getMsg(LANG, "cannot.get.info", {"zh":u"租户Pair" , "en":"vStore Pair"}.get(LANG))
        return (cliUtil.RESULT_NOCHECK, pairIDList, cliRet, errMsg)
 
    if flag != True:
        if not cliUtil.hasCliExecPrivilege(cliRet):
            return (cliUtil.RESULT_NOSUPPORT, pairIDList, cliRet, "")
        return (flag, pairIDList, cliRet, errMsg)
        
    cliRetDictList = cliUtil.getHorizontalCliRet(cliRet)  
    if len(cliRetDictList) == 0:
        return (cliUtil.RESULT_NOCHECK, pairIDList, cliRet, errMsg)
    
   
    for cliRetDict in cliRetDictList:          
        hyperMetroId = cliRetDict.get("ID")
        if not hyperMetroId:
            return (cliUtil.RESULT_NOCHECK, pairIDList, cliRet, errMsg)           
        pairIDList.append(hyperMetroId) 
    
    return (True, pairIDList, cliRet, '')
    
def checkHyperMetroVstorePairStatus(cli , pairIDList):
    '''
    @summary: 检查所有双活租户pair的状态并返回错误信息
    @param cli: cli对象
    @return: （executeFlag, cliRet, errMsg）    
        executeFlag：返回巡检结果     
            cliUtil.RESULT_NOSUPPORT：不支持
            cliUtil.RESULT_NOCHECK：未检查     
            True:  巡检结果为成功
            False: 巡检结果为失败
        cliRet：返回CLI命令的所有回显
        errMsg：巡检结果失败就返回失败信息
    ''' 
    allCliRet = ''
    abnormalPairDict = {}
    pairIdNum = len(pairIDList)
    if pairIdNum >= 300:
        currentProcess = 20
        stepProcess = (1.0 / pairIdNum) * (100 - currentProcess)
    if pairIdNum == 0:
        return (cliUtil.RESULT_NOCHECK, allCliRet, '')
    
    for pairID in pairIDList:
        cmd = "show hyper_metro_vstore_pair check_session pair_id=%s"% pairID
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet) 
        
        if pairIdNum >= 300:
            currentProcess = common.refreshProcessByStep(currentProcess, stepProcess, py_java_env, LOGGER)
            
        if flag == False: 
            errMsg = common.getMsg(LANG, "cannot.get.info", {"zh":u"NAS双活租户Pair" , "en":"NAS HyperMetro vStore Pair"}.get(LANG))
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if flag is not True:
            if not cliUtil.hasCliExecPrivilege(cliRet):
                return cliUtil.RESULT_NOSUPPORT, allCliRet, errMsg
            return flag, allCliRet, errMsg
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (cliUtil.RESULT_NOCHECK, allCliRet, "")
        
        #获取pair租户巡检结果不正常的指标
        if len(getAbnormalPair(cliRet)) != 0:
            abnormalPairDict[pairID] = getAbnormalPair(cliRet)
                         
    if len(abnormalPairDict) == 0:
        return (True, allCliRet, "")
    
    errMsg = ''  
    for vstorepair in abnormalPairDict.keys():
        errMsg += common.getMsg(LANG, "vstore.pair.status.check.failed", vstorepair)
        for items in abnormalPairDict.get(vstorepair):
            errMsg += '\n'+items
    return (False, allCliRet, errMsg)
        

def getAbnormalPair(cliRet):
    '''
    @summary: 获取状态检查不通过的pair id
    @param cli: CLI回显
    @return:abnormalstauts：不通过的状态    
        
    ''' 
    
    abnormalstauts = {}
    storePairNormalStatus = {'Check Logical Port Health Status':'OK',
                             'Check Logical Port Config':'OK',
                             'Check File System Health Status':'OK',
                             'Check File System Config':'OK',
                             'Running Status':'Normal',
                             'Config Status':'Normal'} 
    
    storePairStatuscliRetDict = cliUtil.getCliRetDict(cliRet)
    for statusItem in storePairNormalStatus.keys():
        if storePairNormalStatus.get(statusItem,'') != storePairStatuscliRetDict.get(statusItem,''):     
            abnormalstauts[statusItem] = storePairStatuscliRetDict[statusItem] 
    return  abnormalstauts

def isProductModelAndVersionSupport(cli, lang):
    '''
    @summary: 检查型号和版本是否支持
    @param cli: cli对象
    @param lang: 语言对象
    @return: （isSucc, cliRet, errMsg）    
        isSucc：是否支持     
            cliUtil.RESULT_NOCHECK：未检查     
            True:  支持
            False: 不支持
        cliRet：返回CLI命令的所有回显
        errMsg：包含失败状态的错误信息       
    ''' 
    
    allCliRet = ""
    isSucc, model, cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, lang)
    allCliRet = common.joinLines(allCliRet, cliRet)
    
    if not isSucc:
        return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
    
    if model == '2800 V3':
        return (False, allCliRet, '')
    
    cliRet, softwareVersionList, hotPatchVersionList = common.parse_upgradePackage(cli, lang)
    allCliRet = common.joinLines(allCliRet, cliRet[1])
    
    if not cliRet[0]:
        return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
    
    softwareVersion = softwareVersionList[0].get("Current Version",'')
    
    if "V300R006C00" == softwareVersion:
        return (False, allCliRet, '')
    
    return (True, allCliRet, '')
    
    
    
    
    
    
    
    