# -*- coding: UTF-8 -*-
import cliUtil
import common
import common_utils
from cbb.frame.base import baseUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

def execute(cli):
    '''
        是否有临时license检查：
    1 如果license不存在表示正常；
    2 如果license存在且无Left Day(s)项，表示正常。
    3 Left Day(s)小于1825表示不正常，否则表示正常。 
    '''
    cliRet = ""
    errMsg = ""

    try:
        product_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
        if baseUtil.is_micro_dev(product_model) and common_utils.is_flush_through_mode(cli, LANG, LOGGER):
            return (cliUtil.RESULT_NOSUPPORT, "System mode: pass-through mode.", errMsg)
        cmd = "show license"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLines = cliRet.splitlines()
        for line in cliRetLines:
            line = line.strip()
            if not line.startswith("Left Day(s)"):
                continue
            
            leftDaysList = line.split(":")
            if len(leftDaysList) != 2:
                errMsg = common.getMsg(LANG, "cannot.get.license.service.auth.info")
                LOGGER.logNoPass("Cannot get information about LICENSE SERVICE AUTH TYPE")
                return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0
            
            leftDays = leftDaysList[1].strip()
            LOGGER.logNoPass("leftDays:%s" % leftDays)
            if int(leftDays) < 1825:
                errMsg = common.getMsg(LANG, "system.exists.temporary.license")
                LOGGER.logNoPass("LICENSE SERVICE AUTH TYPE is DEMO, a temporary license exists")
                return (False, cliRet, errMsg)
            
        return (True, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
