# -*- coding: UTF-8 -*-
import common
import cliUtil
import traceback
from common_utils import get_err_msg
from common import UnCheckException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env


def execute(cli):
    """
    控制器链路冗余检查
    :param cli:
    :return:link_redundant
    """
    link_redundant = LinkRedundantCheck(cli)
    flag, msg = link_redundant.execute_check()
    return flag, "\n".join(link_redundant.all_cli_ret), msg


class LinkRedundantCheck:
    def __init__(self, cli):
        self.cli = cli
        self.lang = LANG
        self.env = PY_JAVA_ENV
        self.logger = LOGGER
        self.all_cli_ret = []
        self.err_msg_list = []

    def execute_check(self):

        try:
            return self.check_link_redundant()
        except UnCheckException as e:
            self.logger.logError(str(e))
            return cliUtil.RESULT_NOCHECK, e.errorMsg
        except Exception:
            self.logger.logError(str(traceback.format_exc()))
            err_msg = "query.result.abnormal"
            return cliUtil.RESULT_NOCHECK, common.getMsg(self.lang, err_msg)

    def check_link_redundant(self):
        """
        检查每个控制器的“CheckResult”字段，ok or nok
        :return: True or False
        """
        flag, con_list, err_msg, cli_ret = cliUtil.getControllerIdListWithRet(
                                self.cli, self.lang)
        self.all_cli_ret.append(cli_ret)
        if flag is not True:
            raise UnCheckException(err_msg, cli_ret)

        cmd = "eam lhacheckallnode -devm"
        flag, cli_ret, err_msg = cliUtil.excuteCmdInDebugModel(
            self.cli, cmd, self.lang)
        self.all_cli_ret.append(cli_ret)
        if flag is not True:
            raise UnCheckException(err_msg, cli_ret)
        cliUtil.enterCliModeFromDebugModel(self.cli, self.lang)
        result = cliUtil.getHorizontalNostandardCliRet(cli_ret)
        con_err_msg = "software.link.redundant.controller.error"
        if not result:
            con_err_list = [get_err_msg(self.lang, con_err_msg, (con,))
                            for con in con_list]
            return False, "".join(con_err_list)

        err_msg = "software.link.redundant.not.pass"
        for line in result:
            con_list.remove(line.get("Node"))
            if line.get("CheckResult") == "nok":
                params = (line.get("Node", "--"), line.get("ErrCode", "--"))
                self.err_msg_list.append(get_err_msg(self.lang, err_msg, params))
        if con_list:
            con_err_list = [get_err_msg(self.lang, con_err_msg, (con, ))
                            for con in con_list]
            self.err_msg_list.extend(con_err_list)

        return not bool(self.err_msg_list), "".join(self.err_msg_list)
