# -*- coding: UTF-8 -*-
import datetime
import cliUtil
import common
import expandconfig

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
expConfigObj = expandconfig.ExpandConfig(py_java_env)

def execute(cli):
    '''
        硬盘域多层级均衡导致双控复位检查； 
        步骤1 以admin用户登录设备。
        步骤2 执行命令show system general获取系统当前时间。
        步骤3 执行命令show event from_time=From_Time to_time=To_Time|
        filterRow column=ID predict=equal_to value=0x100F00CF0027，查询系统在最近两小时内是否发生过复位，
                    其中To_Time为系统当前时间，From_Time为当前时间之前两小时的时间。
         步骤3回显中显示系统最近两小时内发生过复位，则检查不通过，否则检查通过。
    '''
    
    flag = True
    allCliRet = ""
    errMsg = ""
    
    riskSoftwareVersionList = ["V300R003C10", "V300R003C10SPC100", "V300R003C20"
                               ,"V300R003C20SPC100", "V300R003C20SPC200", "V300R005C00"
                               ,"V300R005C00SPC300", "V300R006C00", "V300R006C00SPC100"]
    
    repairVersionPathDict = {"V300R003C20SPC200" : "V300R003C20SPH203"}
    try:
        #获取软件版本号和补丁版本号，并判断是否为风险版本
        checkRet, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
        allCliRet += checkRet[1]
        
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (cliUtil.RESULT_NOCHECK, allCliRet, checkRet[2])

        result, currentVersion, errInfo = common.getCurrentVersion(currentVersionDictList, LANG)
        if not result:
            errMsg += errInfo
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if str(currentVersion).upper() not in riskSoftwareVersionList :
            return (cliUtil.RESULT_NOSUPPORT, allCliRet, errMsg)
        
        result, hotPatchVersion, errMsg = common.getHotPatchVersion(hotPatchVersionDictList, LANG)
        if not result:
            errMsg += errInfo
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        #判断是否安装解决该问题热补丁
        if currentVersion in repairVersionPathDict and hotPatchVersion >= repairVersionPathDict.get(currentVersion):
            return (True, allCliRet, errMsg)

        #判断是否为两个及以上层级
        diskLevelInfo = expConfigObj.getExpDiskLevel()
        LOGGER.logInfo("get disk level Info:%s" %diskLevelInfo)
        if not diskLevelInfo:
            LOGGER.logInfo("Donot have expanded domain.")
            return (True, allCliRet, errMsg)

        riskDomains = []
        for domain in diskLevelInfo:
            if(len(diskLevelInfo.get(domain)) >= 2):
                riskDomains.append(domain)
                continue

        if not riskDomains:
            LOGGER.logInfo("No more than 2 levels of expansion of the hard disk domain")
            return (True, allCliRet, errMsg)

        #获取当前时间
        timeRet = cliUtil.getCurrentTime(cli, LANG, LOGGER)
        
        allCliRet += timeRet[1]
        errMsg += timeRet[2]
        
        if timeRet[0] != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        currentTime = timeRet[-1]
        
        #按当前时间判断两小时内是否发生过系统复位
        resetRet = isNotReseted(cli, currentTime)
        
        allCliRet += resetRet[1]
        errMsg += resetRet[2]
        
        if resetRet[0] != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        #获取回显都正常的情况下，返回是否复位的标志位
        flag = resetRet[-1]
        if not flag:
            riskDomains.sort()
            errMsg = common.getMsg(LANG, "reseted.in.limit.time", ",".join(riskDomains))
        
        return (flag, allCliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

    
def isNotReseted(cli, currentTime):
    """
    @summary: 执行命令show event from_time=From_Time to_time=To_Time|
              filterRow column=ID predict=equal_to value=0x100F00CF0027检查系统在最近两小时内是否发生过复位
    @return: 
        flag：True/False，方法是否正常结束
        cliRet：CLI回显
        errMsg：方法异常结束时的原因
        notReseted:两小时内是否发生过复位，True表示未发生过，False表示发生过
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    notReseted = True
    
    try:
        
        cmd = "show event from_time=%s to_time=%s|filterRow column=ID predict=equal_to value=0x100F00CF0027"
        
        dateObj = datetime.datetime.strptime(currentTime,"%Y-%m-%d/%H:%M:%S")+datetime.timedelta(hours=-2)
        startTime = dateObj.strftime("%Y-%m-%d/%H:%M:%S")   
        cmd = cmd % (startTime, currentTime)
        
        execRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = execRet[1]
        
        #命令执行失败
        if execRet[0] != True:
            errMsg = execRet[2]
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg, notReseted)
         
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg, notReseted)
        
        #解析回显为字典列表
        resetEvents = cliUtil.getHorizontalCliRet(cliRet)
        if len(resetEvents) > 0:
            notReseted = False

        return (flag, cliRet, errMsg, notReseted)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"), notReseted)
