# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
SPECIAL_STAND_NUM_TYPE = ["S5500T", "S2600T"]


def execute(cli):
    """
       硬盘域创建策略检查: 
       1） 当硬盘域不存在时，则检查通过； 2）当所有硬盘域中的硬盘同引擎且硬盘域中同类型的硬盘容量相同（保险箱盘除外，保险箱盘最大可比同类型非保险箱盘少10GB），则检查通过；否则检查结果为建议优化；   
       3） 其他情况检查不通过；
      备注：硬盘ID中首位数字表示引擎号，引擎号相同表示同引擎，否则表示跨引擎；
      S2600T和S5500T设备没有板载SSD盘，比较特殊，其保险箱盘对应误差值31G

    """
    all_cli_ret_list = []
    stand_number = 10
    try:
        flag, ret, msg = cliUtil.getProductModel(cli, LANG)
        all_cli_ret_list.append(ret)
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, ret, msg
        if ret in SPECIAL_STAND_NUM_TYPE:
            stand_number = 31

        coffer_disk_list = get_coffer_disk(cli, all_cli_ret_list)
        err_msg_list = check_disk_domain_create_strategy(
            cli, all_cli_ret_list, stand_number, coffer_disk_list
        )
        if err_msg_list:
            return (
                cliUtil.RESULT_WARNING,
                "\n".join(all_cli_ret_list),
                "".join(err_msg_list) + common.getMsg(LANG, "disk.domain.create.strategy.warning.sugg"),
            )
        return True, "\n".join(all_cli_ret_list), ""
    except common.UnCheckException as e:
        return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret_list), e.errorMsg
    except Exception as exception:
        LOGGER.logException(exception)
        return (
            cliUtil.RESULT_NOCHECK,
            "\n".join(all_cli_ret_list),
            common.getMsg(LANG, "query.result.abnormal"),
        )


def check_disk_domain_create_strategy(
    cli, all_cli_ret_list, stand_number, coffer_disk_list
):
    err_msg_list = []
    cmd = "show disk_domain general"
    flag, ret, msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret_list.append(ret)
    if flag is not True:
        raise common.UnCheckException(msg, "".join(all_cli_ret_list))
    for line in cliUtil.getHorizontalCliRet(ret):
        domain_id = line.get("ID")
        cmd = "show disk in_domain disk_domain_id={}".format(domain_id)
        flag, ret, msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        all_cli_ret_list.append(ret)
        if flag is not True:
            raise common.UnCheckException(msg, "".join(all_cli_ret_list))
        is_same_engine = cliUtil.checkDiskInSameEngine(ret)
        if not is_same_engine:
            err_msg_list.append(
                common.getMsg(LANG, "diskdomain.engine.info", domain_id)
            )
        err_type_list, err_speed_type_list = cliUtil.checkDiskCapacity(
            ret, coffer_disk_list, stand_number, LOGGER
        )
        for disk_type in err_type_list:
            err_msg_list.append(
                common.getMsg(
                    LANG,
                    "diskdomain.diskcapacity.info",
                    (domain_id, disk_type),
                )
            )
        for disk_type in err_speed_type_list:
            err_msg_list.append(
                common.getMsg(
                    LANG, "diskdomain.diskspeed.info", (domain_id, disk_type)
                )
            )
    return err_msg_list


def get_coffer_disk(cli, all_cli_ret_list):
    cmd = "show disk general |filterRow column=Coffer\\sDisk predict=equal_to value=Yes"
    flag, ret, msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret_list.append(ret)
    if flag is not True:
        raise common.UnCheckException(msg, "".join(all_cli_ret_list))
    return [line.get("ID") for line in cliUtil.getHorizontalCliRet(ret)]
