# -*- coding: UTF-8 -*-
import cliUtil
import traceback
import common
import re
from common import UnCheckException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
allCliRet = ""

def execute(cli):
    '''
        成员盘空闲率检查 
        步骤2   执行命令：show upgrade package，查询系统版本与热补丁版本
        
        步骤3   执行命令：show enclosure |filterRow column=Logic\sType predict=equal_to value=Engine，查询系统引擎ID列表，记录关键字” Health Status”字段值为” Normal”且关键字” Running Status”字段值为” Online”的ID
        
        步骤4  执行命令：show controller general，查询系统控制器信息，记录关键字” Controller”所对应的控制器ID及关键字” Location”对应的控制器所在的引擎ID
        
        步骤5  执行命令：show disk_domain general，查询硬盘域的信息，记录关键字” Health Status”字段值为” Normal”且关键字” Running Status”字段值为” Online”的DiskDomain ID
        
        步骤6  执行命令：change user_mode current_mode user_mode=developer，进入developer模式
        
        步骤7执行命令：show block_manager bitmap disk_pool_id=DiskDomain ID（步骤5记录） space_type=data controller=控制器ID（步骤4记录引擎所对应控制器），查询各盘空闲率，记录该引擎关键字” Free Percent”所对应的列表值
        
        步骤8 执行命令：show block_manager disk_pool_quota disk_pool_id= DiskDomain ID（步骤5记录）disk_pool_type=performance controller=控制器ID（步骤7命令参数的控制器ID），查询tier空闲率，
                记录关键字” Data Free Percent(%)” 、”Data Total Size(sectors)”、 ” Data Hot Spare Quota(sectors)”所对应的字段值
        
        步骤9 执行命令：show zone_recycle list pool_id= DiskDomain ID（步骤5记录） controller=控制器ID（步骤4记录），查询DiskDomain的垃圾量，
                记录关键字” garbage level”所对应的字段值及关键字” datazone num”所对应的字段值
    '''
    global allCliRet
    errMsg = ""
    try:
        #步骤2 检查设备版本及热补丁是否处于检查版本内        
        flag = isRiskVersion(cli)
        common.refreshProcess(PY_JAVA_ENV, 10, LOGGER)
        if not flag:
            return (True, allCliRet, errMsg)

        #步骤3 查询设备引擎ID
        engineIdList = queryDeviceEngineID(cli)
        common.refreshProcess(PY_JAVA_ENV, 20, LOGGER)

        #步骤4 查询控制器信息
        engineIdList = queryDeviceControllerInfo(cli, engineIdList)
        common.refreshProcess(PY_JAVA_ENV, 35, LOGGER)

        #步骤5 查询硬盘域ID
        domainIdList = queryDiskDomainID(cli)
        common.refreshProcess(PY_JAVA_ENV, 45, LOGGER)

        #步骤7-9 已确定硬盘域的情况下，已引擎分组 循环执行步骤7-9
        for domainId in domainIdList:
            controlLists = engineIdList.values()
            common.refreshProcess(PY_JAVA_ENV, 60, LOGGER)
            for controllerList in controlLists:
                #步骤7 查询各盘空闲率，记录该引擎关键字” Free Percent”所对应的列表值
                controllerId, freePercentList = queryIdleness(cli, domainId, controllerList)
                #步骤8 查询tier空闲率
                flag, tierFree, deleteValue = queryTierIdleness(cli, domainId, controllerId, freePercentList)
                if flag:
                    continue
                #步骤9 查询控制器垃圾量
                flag, errMsg = queryControllerRubbish(cli, tierFree, deleteValue, domainId, controllerList)
                common.refreshProcess(PY_JAVA_ENV, 80, LOGGER)
                if not flag:
                    return (False, allCliRet, errMsg)

        return (True, allCliRet, errMsg)

    except UnCheckException, unCheckException:
        LOGGER.logError(str(traceback.format_exc()))
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if unCheckException.flag == False:
            return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg)
        return (unCheckException.flag, unCheckException.cliRet, unCheckException.errorMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

def queryControllerRubbish(cli, tierFree, deleteValue, domainId, controllerList):
    '''
    @summary: 查询控制器垃圾量
    @param param: tierFree
    @param param: deleteValue
    @param param: domainId
    @param param: controllerList 
    @param cli: cli回显 

    @return: 
        Flag: True  返回通过
              False 返回不通过
    '''
    global allCliRet
    cmd = "show zone_recycle list pool_id=%s controller=%s"
    sum20 = 0.0
    sum25 = 0.0
    errMsg = ""

    LEVEL = "garbage level"
    DATA_NUM = "datazone num"

    for controllerId in controllerList:
        cmdStr = cmd % (domainId, controllerId)
        flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmdStr, True, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)

        #检查权限    
        if not cliUtil.hasCliExecPrivilege(cliRet):
            errMsg = cliUtil.getMsg(LANG, "has.not.cli.privilege")
            raise UnCheckException(errMsg, allCliRet, cliUtil.RESULT_NOSUPPORT)

        if flag != True:
            LOGGER.logInfo("Get controller rubbish has same error.")
            raise UnCheckException(errMsg, allCliRet)

        dictList = cliUtil.getHorizontalCliRet(cliRet)
        if len(dictList) == 0:
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            raise UnCheckException(errMsg, allCliRet)

        for dictInfo in dictList:
            garLevel = dictInfo.get(LEVEL, "").strip()
            dataZone = dictInfo.get(DATA_NUM, "").strip()

            if not garLevel.isdigit():
                errMsg = common.getMsg(LANG, "query.result.abnormal")
                raise UnCheckException(errMsg, allCliRet)

            garLevel = int(garLevel)
            if garLevel == 20:
                continue

            numList = transStrToFloat(dataZone)

            if garLevel > 20:
                sum20 += numList[0]

            if garLevel > 25:
                sum25 += numList[0]

    LOGGER.logInfo("tierFree is : %s,deleteValue is : %s,sum20 is : %s,sum25 is : %s" % \
                   (tierFree, deleteValue, sum20, sum25))

    if tierFree >= 20 and deleteValue < 15 and sum25 < 100:
        errMsg = common.getMsg(LANG, "device.has.storagepool.error")
        return (False, errMsg)

    if tierFree < 20 and sum20 < 100:
        errMsg = common.getMsg(LANG, "device.has.possible.storagepool.error")
        return (False, errMsg)

    return (True, errMsg)

def queryTierIdleness(cli, domainId, controllerId, freePercentList):
    '''
    @summary: 查询tier空闲率
    @param param:domainId 
    @param param:controllerId 返回正确回显的控制器ID
    @param param:freePercentList 列表值
    
    @param param:Data Free Percent(%)
    @param param:Data Total Size(sectors)
    @param param:Data Hot Spare Quota(sectors)  
    @param cli: cli回显 

    @return: tierFree tier空闲率
    @return: deleteValue 列表值最大值与最小值的差值
    '''
    global allCliRet
    cmd = "show block_manager disk_pool_quota disk_pool_id=%s disk_pool_type=performance controller=%s" % \
            (domainId, controllerId)
    errMsg = ""

    DATA_FREE = "Data Free Percent(%)"
    DATA_HOT = "Data Hot Spare Quota(sectors)"
    DATA_TOTAL = "Data Total Size(sectors)"

    flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)

    #检查权限    
    if not cliUtil.hasCliExecPrivilege(cliRet):
        errMsg = cliUtil.getMsg(LANG, "has.not.cli.privilege")
        raise UnCheckException(errMsg, allCliRet, cliUtil.RESULT_NOSUPPORT)

    if flag != True:
        LOGGER.logInfo("Get tier idleness has same error.")
        raise UnCheckException(errMsg, allCliRet)

    dictList = cliUtil.getVerticalCliRet(cliRet)
    if len(dictList) == 0:
        errMsg = common.getMsg(LANG, "query.result.abnormal")
        raise UnCheckException(errMsg, allCliRet)

    tierIdlenessMap = dictList[0]
    tierFree = tierIdlenessMap.get(DATA_FREE, "").strip()
    dataTotalSize = tierIdlenessMap.get(DATA_TOTAL, "").strip()
    hotSpareSize = tierIdlenessMap.get(DATA_HOT, "").strip()

    numList = transStrToFloat(tierFree, dataTotalSize, hotSpareSize)
    tierFree = numList[0]

    #执行运算    freePercent列值  - hotSpareSize * 100 / DataTotalSize
    flag, deleteValue = countNewFreePercent(freePercentList, numList)

    return (flag, tierFree, deleteValue)

def countNewFreePercent(freePercentList, numList):
    '''
            执行计算:freePercent列值  - hotSpareSize * 100 / DataTotalSize
            求出新的diskFreePercent列表值及对应的max min avg
    '''
    deleteValue = 0.0
    count = 0
    #执行计算:freePercent列值  - hotSpareSize * 100 / DataTotalSize
    diskFreePercenList = []
    minuend = numList[2] * 100 / numList[1]
    for freePercent in freePercentList:
        newFreePercent = freePercent - minuend if freePercent > minuend else 0.0
        diskFreePercenList.append(newFreePercent)

    LOGGER.logInfo("The diskFreePercenList is: %s" % diskFreePercenList)

    if len(diskFreePercenList) == 0:
        LOGGER.logInfo("Get the diskFreePercentList is null.")
        errMsg = common.getMsg(LANG, "query.result.abnormal")
        raise UnCheckException(errMsg, allCliRet)

    maxFreePercent = max(diskFreePercenList)
    minFreePercent = min(diskFreePercenList)
    avgFreePercent = sum(diskFreePercenList) / len(diskFreePercenList)
    LOGGER.logInfo("The maxFreePercent is: %s,minFreePercent is: %s,avgFreePercent is: %s" % \
                   (maxFreePercent, minFreePercent, avgFreePercent))

    #业务逻辑，如果 min >= 50,当前引擎通过    
    if minFreePercent >= 50:
        return (True, deleteValue)

    deleteValue = maxFreePercent - minFreePercent

    #业务逻辑
    if len(diskFreePercenList) < 25:
        return (False, deleteValue)

    for freePercent in diskFreePercenList:
        if freePercent > avgFreePercent:
            count += 1

    #业务逻辑，如果 列表值大于等于平均值条数超过25,当前引擎通过
    if count >= 25:
        return (True, deleteValue)

    return (False, deleteValue)

def queryIdleness(cli, domainId, controllerList):
    '''
    @summary: 查询各盘空闲率，记录该引擎关键字” Free Percent”所对应的列表值
    @param cli: cli回显 
    @param domainId:  domainId
    @param controllerList: 分组引擎下工作的 控制器ID List 
    @return: freePercentList ： freePercent 列表值 
             controllerId ： 返回正确回显的控制器ID
    '''
    global allCliRet
    cmd = "show block_manager bitmap disk_pool_id=%s space_type=data controller=%s"
    freePercentList = []
    controllerId = ""

    FREE_PERCENT = "Free Percent(%)"

    for controlId in controllerList:
        cmdStr = cmd % (domainId, controlId)
        flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmdStr, True, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)

        #检查权限    
        if not cliUtil.hasCliExecPrivilege(cliRet):
            errMsg = cliUtil.getMsg(LANG, "has.not.cli.privilege")
            raise UnCheckException(errMsg, allCliRet, cliUtil.RESULT_NOSUPPORT)

        if flag != True:
            LOGGER.logInfo("The current controller does not return correct echo: %s" % controlId)
            continue

        dictList = cliUtil.getHorizontalCliRet(cliRet)
        if len(dictList) == 0:
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            raise UnCheckException(errMsg, allCliRet)

        for dictInfo in dictList:
            freePercent = dictInfo.get(FREE_PERCENT, "").strip()

            if freePercent == "" or freePercent == '--':
                errMsg = common.getMsg(LANG, "query.result.abnormal")
                raise UnCheckException(errMsg, allCliRet)

            numList = transStrToFloat(freePercent)
            freePercentList.append(numList[0])

        controllerId = controlId
        break

    LOGGER.logInfo("The freePercentList is : %s" % freePercentList)
    if len(freePercentList) == 0:
        errMsg = common.getMsg(LANG, "device.no.normal.error")
        raise UnCheckException(errMsg, allCliRet)

    return (controllerId, freePercentList)

def transStrToFloat(*numStr):
    '''
    @summary: 字符串转换为float,并输出
    @param *numStr: 输入的需要判定的  参数数组
    
    @return: numList
                                     转化为float的列表
    '''
    numList = []
    value = re.compile(r"[0-9]*\.?[0-9]+")
    for num in numStr:
        result = value.match(num)
        if result:
            num = float(num)
            numList.append(num)
        else:
            LOGGER.logInfo("【transStrToFloat】 has same error: %s" % num)
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            raise UnCheckException(errMsg, allCliRet)

    return numList

def queryDiskDomainID(cli):
    '''
    @summary: 查询硬盘域ID
    @param cli: cli回显 

    @return: domainIDList 放置与disk_main ID 
        Flag:
    '''
    global allCliRet
    cmd = "show disk_domain general"
    domainIDList = []

    HEALTH_STATUS = "Health Status"
    RUN_STATUS = "Running Status"
    DISKDOMAIN_ID = "ID"

    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        LOGGER.logInfo("Get the device disk_domain has same error.")
        raise UnCheckException(errMsg, allCliRet)

    if cliUtil.queryResultWithNoRecord(cliRet):
        LOGGER.logInfo("The device is no disk_domain.")
        raise UnCheckException(errMsg, allCliRet, True)

    dictList = cliUtil.getHorizontalCliRet(cliRet)
    if len(dictList) == 0:
        errMsg = common.getMsg(LANG, "query.result.abnormal")
        raise UnCheckException(errMsg, allCliRet)

    for diskDomainInfo in dictList:
        health = diskDomainInfo.get(HEALTH_STATUS, "").strip()
        runStatus = diskDomainInfo.get(RUN_STATUS, "").strip()
        domainID = diskDomainInfo.get(DISKDOMAIN_ID, "").strip()

        if health.lower() != common.STATUS_NORMAL.lower():
            continue

        if runStatus.lower() != common.STATUS_ONLINE.lower():
            continue

        if domainID == "" or domainID == '--':
            continue

        domainIDList.append(domainID)

    if len(domainIDList) == 0:
        errMsg = common.getMsg(LANG, "device.no.normal.controller")
        raise UnCheckException(errMsg, allCliRet)

    return domainIDList

def queryDeviceControllerInfo(cli, engineIdList):
    '''
    @summary: 查询设备控制器信息
    @param cli: cli回显 

    @return: engineIdList
        Flag:
            True:engineIdList 存在值 则证明正确解析出引擎ID 
            False: engineIdList无值，解析失败
    '''
    global allCliRet
    cmd = "show controller general"
    errMsg = ""

    CONTROLLER = "Controller"
    LOCATION = "Location"

    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        LOGGER.logInfo("Get device controller has same error.")
        raise UnCheckException(errMsg, allCliRet)

    dictList = cliUtil.getVerticalCliRet(cliRet)
    if len(dictList) == 0:
        errMsg = common.getMsg(LANG, "query.result.abnormal")
        raise UnCheckException(errMsg, allCliRet)

    for controllerInfo in dictList:
        controToLocation = controllerInfo.get(LOCATION, "").strip()
        controllerID = controllerInfo.get(CONTROLLER, "").strip()

        if controToLocation == "" or controToLocation == '--' or \
            controllerID == "" or controllerID == '--':
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            raise UnCheckException(errMsg, allCliRet)

        for engineID in engineIdList:
            if engineID in controToLocation:
                controlList = engineIdList.get(engineID)
                controlList.append(controllerID)
                engineIdList[engineID] = controlList
                continue

    LOGGER.logInfo("The device engine to controller is : %s" % engineIdList)
    for controllerList in engineIdList.values():
        if len(controllerList) == 0:
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            raise UnCheckException(errMsg, allCliRet)

    return engineIdList

def queryDeviceEngineID(cli):
    '''
    @summary: 查询设备引擎ID
    @param cli: cli回显 

    @return: engineIdList
        Flag:
            True:engineIdList 存在值 则证明正确解析出引擎ID 
            False: engineIdList无值，解析失败
    '''
    global allCliRet
    cmd = "show enclosure |filterRow column=Logic\sType predict=equal_to value=Engine"
    errMsg = ""
    engineIdList = {}

    HEALTH_STATUS = "Health Status"
    RUN_STATUS = "Running Status"
    ENG_ID = "ID"

    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        LOGGER.logInfo("Get device has same error.")
        raise UnCheckException(errMsg, allCliRet)

    dictList = cliUtil.getHorizontalCliRet(cliRet)
    if len(dictList) == 0:
        errMsg = common.getMsg(LANG, "query.result.abnormal")
        raise UnCheckException(errMsg, allCliRet)

    for engineInfoMap in dictList:
        health = engineInfoMap.get(HEALTH_STATUS, "").strip()
        runStatus = engineInfoMap.get(RUN_STATUS, "").strip()
        engineID = engineInfoMap.get(ENG_ID, "").strip()

        if health.lower() != common.STATUS_NORMAL.lower():
            continue

        if runStatus.lower() != common.STATUS_ONLINE.lower():
            continue

        if engineID == "" or engineID == '--':
            continue

        engineIdList.setdefault(engineID, [])

    if len(engineIdList) == 0:
        errMsg = common.getMsg(LANG, "device.no.normal.engines")
        raise UnCheckException(errMsg, allCliRet)

    LOGGER.logInfo("The device has engines is: %s" % engineIdList)
    return engineIdList

def isRiskVersion(cli):
    '''
    @summary: 检查软件版本是否有问题
    @param cli: cli回显 
    @attention: 问题版本：V300R001C00 + V300R001C00SPH101
                V300R001C00SPC100 + V300R001C00SPH101
                V300R001C01 + V300R001C01SPH103
                V300R001C01SPC100 + V300R001C01SPH103
    @return: (True/False, cliRet)
        Flag:
            True: 问题版本
            False: 非问题版本
    '''
    global allCliRet
    riskVersionMap = {
                      "V300R001C00":"V300R001C00SPH101",
                      "V300R001C00SPC100":"V300R001C00SPH101",
                      "V300R001C01":"V300R001C01SPH103",
                      "V300R001C01SPC100":"V300R001C01SPH103"
                      }
    #获取版本及热补丁信息
    (succFlag, cliRet, errMsg), softwareVersionList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if succFlag != True:
        LOGGER.logInfo("get package info fail!")
        raise UnCheckException(errMsg, allCliRet)

    #获取版本信息    
    flag, productVersion, errMsg = common.getCurrentVersion(softwareVersionList, LANG)
    if flag != True:
        LOGGER.logInfo("get current product version error. errMsg: %s" % errMsg)
        raise UnCheckException(errMsg, allCliRet)


    productVersion = productVersion.strip()
    if productVersion == "" or productVersion == '--':
        errMsg = common.getMsg(LANG, "query.result.abnormal")
        raise UnCheckException(errMsg, allCliRet)

    #如果设备版本不处于检查范围内，则返回通过    
    if not productVersion in riskVersionMap:
        return False
    LOGGER.logInfo("Device productVersion is in rsikVersion.")

    #检查补丁版本信息,如果大于V300R001C00SPH101或V300R001C01SPH103,则不存在风险
    flag, hotPatchVersion, errMsg = common.getHotPatchVersion(hotPatchVersionList, LANG)
    if flag != True:
        LOGGER.logInfo("get current product version error. errMsg: %s" % errMsg)
        raise UnCheckException(errMsg, allCliRet)

    hotPatchVersion = hotPatchVersion.strip()
    if hotPatchVersion == "":
        errMsg = common.getMsg(LANG, "query.result.abnormal")
        raise UnCheckException(errMsg, allCliRet)

    correctPatchVersion = riskVersionMap.get(productVersion)
    if hotPatchVersion >= correctPatchVersion:
        return False
    LOGGER.logInfo("Device patchtVersion is in rsikVersion.")

    return True
