# -*- coding: UTF-8 -*-
import decimal
import traceback
import cliUtil
import common
import re
import ast
import config
from common import UnCheckException


LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ""
productModel = ""
productVersion = ""
controllerMemory = ""
controllerInC00OrC01 = ""

def execute(cli):
    '''
       检查步骤：
        check_item_software_effective_capacity.py
                有效容量超规格检查(DoradoV3) ； 
                步骤2 执行命令：show system general，获取阵列的硬件型号（Product Model）、软件版本（Product Version）；
                步骤3 执行命令：show storage_pool general，获取阵列中已存在的存储池ID（ID）； 
                步骤4 执行命令：show controller general，获取阵列的单控内存大小（Cache Capacity）；
                步骤5 执行命令：show storage_pool general pool_id=[ID]（存储池ID），获取存储池的硬盘域ID（Disk Domain ID）、总容量（Total Capacity）、已写入容量（Subscribed Capacity）、LUN写入容量（LUN Subscribed Capacity）；
                步骤6 执行命令：show disk_domain general disk_domain_id=[Disk Domain ID]（硬盘域ID），获取硬盘域的控制器信息（Controller）；
                步骤7 循环步骤5-6，记录所有硬盘域、存储池的相关信息。
        检查标准：
        1、    若步骤2中查询到的设备版本及型号存在于检查范围内则执行之后步骤；否则检查通过。
        2、    若步骤3中存在存储池相关信息则执行之后步骤；否则检查通过。
        3、    根据步骤6中查询到的Controller（XA/XB/XC/XD）计算存储池归属逻辑引擎（ENGINE_ID）：
                        若设备型号为Dorado18000 V3，则ENGINE_ID = X * 2（XA/XB）、ENGINE_ID = X * 2 + 1（XC/XD），如：0A/0B 逻辑引擎0，0C/0D 逻辑引擎1，1A/1B 逻辑引擎2，1C/1D 逻辑引擎3。
                        若设备型号为检查范围内其他型号，则ENGINE_ID = X（XA/XB），如：0A/0B 逻辑引擎0，1A/1B 逻辑引擎1（当前版本内设备无C/D逻辑引擎）。
                        根据以上计算结果分别统计所有存储池的归属引擎计数ENGINE_ID_NUM。
        4、    计算并获取存储池在对应引擎的LUN预估最大写入容量：LUN Subscribed Capacity / Subscribed Capacity * Total Capacity / ENGINE_ID_NUM
        5、    计算存储池在对应引擎的LUN实际写入容量：LUN Subscribed Capacity / ENGINE_ID_NUM
        6、    对应逻辑引擎的LUN预估最大写入容量为所有存储池在此引擎的LUN预估最大写入容量之和
        7、    对应逻辑引擎的LUN实际写入容量为所有存储池在此引擎的LUN实际写入容量之和
        8、    若任一逻辑引擎的LUN实际写入容量 / 用户有效容量  > 80%，则检查不通过
        9、    若任一逻辑引擎的LUN实际写入容量 / 用户有效容量  > 50%，且逻辑引擎的LUN预估最大写入容量 / 用户有效容量 > 80%，则检查不通过，否则检查通过
    '''
    global ALL_CLI_RET
    flag = True
    errMsg = ""

    try:
        #步骤2 执行命令：show system general，获取阵列的硬件型号（Product Model）、软件版本（Product Version）
        flag, errMsg = isVersionSupport(cli, LANG)
        #如果版本在版本中，则继续检查，否则则通过
        if flag != False:
            LOGGER.logNoPass("This version does not need to be checked.")
            return flag, ALL_CLI_RET, errMsg
        
        #步骤3 执行命令：show storage_pool general，获取阵列中已存在的存储池ID（ID）；        
        flag, poolIDList, errMsg = getStoragePoolID(cli, LANG)
        if len(poolIDList) < 1:
            LOGGER.logNoPass("getting storagePool information failure .")
            return flag, ALL_CLI_RET, errMsg
        
        #步骤4 执行命令：show controller general，获取阵列的单控内存大小（Cache Capacity）；        
        flag, controllerMemory, errMsg = getStorageControllerMemory(cli, LANG)
        if flag != True:
            LOGGER.logNoPass("getting controller information failure .")
            return flag, ALL_CLI_RET, errMsg

        #步骤5 执行命令：show storage_pool general pool_id=[ID]（存储池ID），
        #获取存储池的硬盘域ID（Disk Domain ID）、总容量（Total Capacity）、已写入容量（Subscribed Capacity）、LUN写入容量（LUN Subscribed Capacity）；
        capacityDict = {}
        for poolID in poolIDList:
            flag, capacityDict, errMsg = getStroagePoolCapacity(cli, LANG, poolID, capacityDict)
            if flag != True:
                LOGGER.logNoPass("getting storage pool information failure .")
                return flag, ALL_CLI_RET, errMsg
            
        #步骤6 执行命令：show disk_domain general disk_domain_id=[Disk Domain ID]（硬盘域ID）
        #获取硬盘域的控制器信息（Controller）；        
        flag, capacityDict, engineInfoMap, errMsg = getControllerInDomain(cli, LANG, capacityDict)
        if flag != True:
            return flag, ALL_CLI_RET, errMsg
        #计算并获取存储池在对应引擎的LUN预估最大写入容量：
        #LUN Subscribed Capacity / Subscribed Capacity * Total Capacity / ENGINE_ID_NUM
        # 计算存储池在对应引擎的LUN实际写入容量：
        #LUN Subscribed Capacity / ENGINE_ID_NUM        
        capacityDict = getFactAndEstCapForEngineInPool(capacityDict)

        LOGGER.logNoPass("the capacityDict is: " + str(capacityDict))

        LOGGER.logNoPass("the engineInfoMap is: " + str(engineInfoMap))
        
        #计算每一逻辑引擎的对应容量        
        capacityDictInEngines = getFactAndEstCapForEngineInTotal(capacityDict)
        LOGGER.logNoPass("the capacityDictInEngines is: " + str(capacityDictInEngines))

        
        #获取设备对应的用户容量        
        flag, errMsg = getDevForCapacity(capacityDictInEngines, engineInfoMap)
        if flag != True:
            return flag, ALL_CLI_RET, errMsg
        return flag, ALL_CLI_RET, errMsg

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))

def getDevForCapacity(capacityDictInEngines, engineInfoMap):
    global productModel
    global productVersion
    global controllerMemory
    
    errMsg = ""
    modelDict = config.CHECK_DEV_CAPACITY.get(productModel, "")
    if len(modelDict) == 0:
        errMsg = common.getMsg(LANG, "cannot.get.controller.info")
        LOGGER.logNoPass("Cannot get information about check_dev_capacity.")
        return cliUtil.RESULT_NOCHECK, errMsg
    
    versionDict = modelDict.get(controllerMemory, "")
    if len(versionDict) == 0:
        errMsg = common.getMsg(LANG, "cannot.get.controller.info")
        LOGGER.logNoPass("Cannot get information about check_dev_capacity.")
        return cliUtil.RESULT_NOCHECK, errMsg
    
    devCapacity = versionDict.get(productVersion, 1)
    if devCapacity == 1:
        errMsg = common.getMsg(LANG, "cannot.get.controller.info")
        LOGGER.logNoPass("Cannot get information about check_dev_capacity.")
        return cliUtil.RESULT_NOCHECK, errMsg
    #判断同一逻辑引擎下的数据
    flag = True
    errControllerList = []
    for engineID in capacityDictInEngines:
        engineInfo = capacityDictInEngines.get(engineID , {})
        estimateMaxInEngine = engineInfo.get("estimateMaxInEngine", 0)
        factMaxInEngine = engineInfo.get("factMaxInEngine", 0)

        if (factMaxInEngine / devCapacity) > 0.8:
            errControllerList.extend(engineInfoMap.get(engineID, []))
            flag = False
            LOGGER.logNoPass("The actual write capacity of LUN is too large, engine id :" + str(engineID))
            LOGGER.logNoPass("The actual write capacity of LUN is too large  :" + str(errControllerList))
        
        if (factMaxInEngine / devCapacity) > 0.5 and (estimateMaxInEngine / devCapacity) > 0.8:
            errControllerList.extend(engineInfoMap.get(engineID, []))
            flag = False
            LOGGER.logNoPass("LUN Predicts Maximum Writing Capacity, engine id :" + str(engineID))
            LOGGER.logNoPass("LUN Predicts Maximum Writing Capacity, errControllerList :" + str(errControllerList))

    if not flag:
        errControllerList = list(set(errControllerList))
        errControllerList.sort()
        errMsg =  common.getMsg(LANG, "check.capacity.too.high", errControllerList)

    return flag, errMsg
    
def getFactAndEstCapForEngineInTotal(capacityDict):
    """
     @summary:以逻辑引擎为单位进行计算
                           计算为每一个逻辑引擎的预估及实际容量（单独存储池中引擎计所对应的数值相加之和）
    
     @return: 
        isSucc：True/False，
        capacityDict: key: 存储池ID value
        engineDict: key 逻辑引擎ID value : capacityDictInEngine
    """

    capacityDictInEngines = {}
    
    for key, value in capacityDict.items():
        logicEngineList = value.get("logicEngineList", "")

        for engineID in logicEngineList:
            capacityDictInEngine = capacityDictInEngines.get(engineID, {})
            if len(capacityDictInEngine) == 0:
                capacityDictInEngine["estimateMaxInEngine"] = value.get("estimateMaxInEngine", 0)
                capacityDictInEngine["factMaxInEngine"] = value.get("factMaxInEngine", 0)
            else:
                capacityDictInEngine["estimateMaxInEngine"] = capacityDictInEngine["estimateMaxInEngine"] + value.get("estimateMaxInEngine", 0)
                capacityDictInEngine["factMaxInEngine"] = capacityDictInEngine["factMaxInEngine"] + value.get("factMaxInEngine", 0)

            capacityDictInEngines[engineID] = capacityDictInEngine
              
    return capacityDictInEngines

def  getFactAndEstCapForEngineInPool(capacityDict):
    """
     @summary:以存储池为单位进行计算
                           计算为存储池下每一个逻辑引擎的预估及实际容量（总量/引擎计数）
    
     @return: 
        isSucc：True/False，
        capacityDict: key:存储池ID value:字典新增单个引擎的预估写入容量、实际写入容量
    """

     #LUN Subscribed Capacity / Subscribed Capacity * Total Capacity / ENGINE_ID_NUM
    for key, value in capacityDict.items():
        estimateMaxInEngine = 0
        factMaxInEngine = 0
        
        totalCapacity = value.get("totalCapacity")
        subscribedCapacity = value.get("subscribedCapacity")
        lunSubscribedCapacity = value.get("lunSubscribedCapacity")
        logicEngineList = value.get("logicEngineList")
        try:
            estimateMaxInEngine = lunSubscribedCapacity / subscribedCapacity * totalCapacity / len(logicEngineList)
            factMaxInEngine = lunSubscribedCapacity / len(logicEngineList)

            LOGGER.logNoPass("Cannot get information about fact or est Capacity in Engine")
        except Exception, exception:
            LOGGER.logNoPass("Cannot get information about fact or est Capacity in Engine")
            LOGGER.logNoPass(exception)
        
        value["estimateMaxInEngine"] = estimateMaxInEngine
        value["factMaxInEngine"] = factMaxInEngine
    
    return capacityDict

def getControllerInDomain(cli, LANG, capacityDict):
    """
     @summary: 获取硬盘域中的控制器信息, 统计存储池的归属引擎计数
     
     @return: 
        isSucc：True/False，
        capacityDict: key:存储池ID value:字典新增归属引擎列表
    """  
    global ALL_CLI_RET
    global productVersion
    global controllerInC00OrC01
        
    errMsg = ""
    engineInfoMap = {}
    for key, value in capacityDict.items():
        cmd = ""
        domainID = value.get("domainID", "")
        if len(domainID) > 0:
            cmd = "show disk_domain general disk_domain_id=%s" % domainID
        
        if len(cmd) < 1:
            continue
    
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)         
        if flag != True:
            return cliUtil.RESULT_NOCHECK, capacityDict, engineInfoMap, errMsg
        
        cliRetList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetList) == 0:
            errMsg += common.getMsg(LANG, "obtain.dd.info.failed", domainID)
            LOGGER.logNoPass("Cannot get information about Disk %s." % domainID)
            return cliUtil.RESULT_NOCHECK, capacityDict, engineInfoMap, errMsg
        
        for cliRetDict in cliRetList:
            controller = cliRetDict.get("Controller", "")
            LOGGER.logNoPass("Get information about controller %s." % controller)
            if "V300R001C00" in productVersion or "V300R001C01" in productVersion or "V300R001C20" in productVersion:
                controller = controllerInC00OrC01
                LOGGER.logNoPass("Get information about controller %s." % controller)
                    
        if "," not in controller:
            errMsg += common.getMsg(LANG, "obtain.dd.info.failed", domainID)
            LOGGER.logNoPass("Cannot get information about controller.")
            return cliUtil.RESULT_NOCHECK, capacityDict, engineInfoMap, errMsg
        
        #获取硬盘域对应控制器                
        controllerList = controller.split(",")
        value["controllerList"] = controllerList
        #根据控制器计算逻辑引擎
        logic_Engine_List, logic_Engine_info = getEngineInStoragePool(controllerList)

        if len(logic_Engine_List) < 1:
            errMsg += common.getMsg(LANG, "obtain.dd.info.failed", domainID)
            return cliUtil.RESULT_NOCHECK, capacityDict,engineInfoMap, errMsg

        value["logicEngineList"] = logic_Engine_List
        value["logicEngineInfo"] = logic_Engine_info
        for key, value in logic_Engine_info.items():
            engineInfo = engineInfoMap.get(key,[])
            engineInfo.extend(value)
            engineInfo = list(set(engineInfo))
            engineInfoMap[key] = engineInfo

        
    return True, capacityDict, engineInfoMap, errMsg

def buildEngineData(logic_Engine_info, engine_id, controller_num, controller):
    controller_list_of_engine = logic_Engine_info.get(engine_id, [])
    controller_list_of_engine.append(str(controller_num) + controller)
    controller_list_of_engine.append(str(controller_num) + controller)
    logic_Engine_info[engine_id] = list(set(controller_list_of_engine))

def getEngineInStoragePool(controllerList):
    global productModel
    logic_Engine_info ={}

    
    controller_A_list = []
    controller_B_list = []
    controller_C_list = []
    controller_D_list = []
    logic_Engine_List = []
    
    controller_A_list = getContorllerNumber(controllerList, controller_A_list, "A")
    controller_B_list = getContorllerNumber(controllerList, controller_B_list, "B")
    controller_C_list = getContorllerNumber(controllerList, controller_C_list, "C")
    controller_D_list = getContorllerNumber(controllerList, controller_D_list, "D")
    
    controller_AB_list = list(set(controller_A_list).intersection(set(controller_B_list)))
    controller_CD_list = list(set(controller_C_list).intersection(set(controller_D_list)))


    if "18000" in productModel:

        for controller_AB in controller_AB_list:
            logic_Engine_List.append(int(controller_AB) * 2)


            buildEngineData(logic_Engine_info, int(controller_AB) * 2, controller_AB, "A")
            buildEngineData(logic_Engine_info, int(controller_AB) * 2, controller_AB, "B")


        for controller_CD in controller_CD_list:
            logic_Engine_List.append(int(controller_CD) * 2 + 1)
            buildEngineData(logic_Engine_info, int(controller_CD) * 2 + 1,controller_CD, "C")
            buildEngineData(logic_Engine_info, int(controller_CD) * 2 + 1,controller_CD, "D")
    else:
        for controller_AB in controller_AB_list:
            logic_Engine_List.append(controller_AB)
            buildEngineData(logic_Engine_info, controller_AB,controller_AB, "A")
            buildEngineData(logic_Engine_info, controller_AB,controller_AB, "B")
    
    LOGGER.logNoPass("logic Engine List is: " + str(logic_Engine_List))
    return logic_Engine_List, logic_Engine_info
    
def getContorllerNumber(controllerList, controller_list, controllerFlag):
    """
     @summary:
     
     @return: 
        isSucc：True/False，
        capacityDict: key:
    """    
    for controller in controllerList:
        if controllerFlag in controller:
            if controller[:controller.find(controllerFlag)].strip().isdigit():
                controller_list.append(controller[:controller.find(controllerFlag)].strip())
    
    return controller_list                 
        
def getStroagePoolCapacity(cli, LANG, poolID, capacityDict):
    """
     @summary: 分别获取存储池的相关容量
     
     @return: 
        isSucc：True/False，
        capacityDict: key:存储池ID value：字典中所含当前存储池中：硬盘域ID及各种容量信息
    """   
    global ALL_CLI_RET
    #用于存储查询出的容量信息    
    poolCapacityDict = {}
    cmd = "show storage_pool general pool_id=%s" % poolID

    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)    
    if flag != True:
        return cliUtil.RESULT_NOCHECK, capacityDict, errMsg
    
    cliRetList = cliUtil.getVerticalCliRet(cliRet)
    if len(cliRetList) == 0:
        return cliUtil.RESULT_NOCHECK, capacityDict, errMsg

    for cliRetDict in cliRetList:
        #硬盘域ID        
        domainID = cliRetDict.get("Disk Domain ID", "")
        #总容量
        totalCapacity = cliRetDict.get("Total Capacity", "")
        #已写入容量
        subscribedCapacity = cliRetDict.get("Subscribed Capacity", "")
        #LUN写入容量
        lunSubscribedCapacity = cliRetDict.get("LUN Subscribed Capacity", "")
     
        if domainID == "" or totalCapacity == "" or subscribedCapacity == "" or lunSubscribedCapacity == "":
            errMsg += common.getMsg(LANG, "get.pool.capacity.failed", poolID)
            return cliUtil.RESULT_NOCHECK, capacityDict, errMsg
     
        #此处统一单位为GB，所返回值未单单位，格式为：0.0
        flag, totalCapacity = common.changUnit2GBDecimal(totalCapacity)
        if flag != True:
            errMsg += common.getMsg(LANG, "get.pool.capacity.failed", poolID)
            return cliUtil.RESULT_NOCHECK, capacityDict, errMsg

        flag, subscribedCapacity = common.changUnit2GBDecimal(subscribedCapacity)
        if flag != True:
            errMsg += common.getMsg(LANG, "get.pool.capacity.failed", poolID)
            return cliUtil.RESULT_NOCHECK, capacityDict, errMsg

        flag, lunSubscribedCapacity = common.changUnit2GBDecimal(lunSubscribedCapacity)
        if flag != True:
            errMsg += common.getMsg(LANG, "get.pool.capacity.failed", poolID)
            return cliUtil.RESULT_NOCHECK, capacityDict, errMsg
    
        #以存储池为单位  将信息存入字典
        poolCapacityDict["domainID"] = domainID.strip()
        poolCapacityDict["totalCapacity"] = totalCapacity
        poolCapacityDict["subscribedCapacity"] = subscribedCapacity
        poolCapacityDict["lunSubscribedCapacity"] = lunSubscribedCapacity
        capacityDict[poolID] = poolCapacityDict
    
    return True, capacityDict, errMsg

def getStorageControllerMemory(cli, LANG):
    """
     @summary: 获取当前设备控制器内存
     
     @return: 
        isSucc：True/False，
    """
    global ALL_CLI_RET
    global controllerMemory
    global productVersion
    global controllerInC00OrC01
    
    cmd = "show controller general"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        return cliUtil.RESULT_NOCHECK, controllerMemory, errMsg
    
    cliRetList = cliUtil.getVerticalCliRet(cliRet)
    if len(cliRetList) == 0:
        errMsg += common.getMsg(LANG, "cannot.get.controller.info")
        LOGGER.logNoPass("Cannot get information about Cacje Ca[acity.")
        return cliUtil.RESULT_NOCHECK, controllerMemory, errMsg
     
    #设备相关特别容错：
    #在V3R1C00/C01设备中，通过存储池查询不出所挂载的控制器，只有在此处进行控制器查询
    #C00只支持2控、1DD；C01只支持2控或者4控、1DD；此DD均部署在所有控制器上            
    if "V300R001C00" in productVersion or "V300R001C01" in productVersion or "V300R001C20" in productVersion:
        for cliRetDict in cliRetList:
            controller = cliRetDict.get("Controller", "")
            if len(controller) > 0:
                #构建控制器回显
                if len(controllerInC00OrC01) == 0:
                    controllerInC00OrC01 = controller
                else:                
                    controllerInC00OrC01 = controllerInC00OrC01 + "," + controller
    
    for cliRetDict in cliRetList:
        controllerMemory = cliRetDict.get("Cache Capacity", "")
        controllerMemory = controllerMemory.strip()
        if re.search("GB" , controllerMemory) and "." in controllerMemory:
             controllerMemory = controllerMemory[:controllerMemory.find(".")]
             if len(controllerMemory) > 0:
                 return True, controllerMemory, errMsg
         
        if re.search("TB" , controllerMemory) and "." in controllerMemory:
             controllerMemory = controllerMemory[:controllerMemory.find(".")]
             if controllerMemory == "1":
                 return True, "1024", errMsg
             
    errMsg += common.getMsg(LANG, "cannot.get.controller.info")
    return cliUtil.RESULT_NOCHECK, controllerMemory, errMsg

def getStoragePoolID(cli, LANG):
    """
     @summary: 获取当前设备存储池ID
     
     @return: 
        isSucc：True/False，
    """
    global ALL_CLI_RET
    poolIDList = []
    cmd = "show storage_pool general"
    # 获取产品型号
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    
    if flag != True:
        errMsg += common.getMsg(LANG, "can.not.get.pool.detail")
        return cliUtil.RESULT_NOCHECK, poolIDList, errMsg
    
    if cliUtil.queryResultWithNoRecord(cliRet):
        return True, poolIDList, errMsg

    cliRetList = cliUtil.getHorizontalCliRet(cliRet)
    for cliRetDict in cliRetList:
        poolID = cliRetDict.get("ID", "") 
        if len(poolID) > 0:
            poolIDList.append(poolID)
            
    if len(poolIDList) < 1:
        errMsg += common.getMsg(LANG, "can.not.get.pool.detail")
        return cliUtil.RESULT_NOCHECK, poolIDList, errMsg
    
    return True, poolIDList, errMsg
        
def isVersionSupport(cli, LANG):
    """
     @summary: 检查当前版本是否支持相关检查
     
     @return: 
        isSucc：True/False，是否支持 ;NULL表示无法获取到版本
    """
    global ALL_CLI_RET
    global productModel
    global productVersion
    
    cmd = "show system general"
    # 获取产品型号
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        return cliUtil.RESULT_NOCHECK, errMsg 

    cliRetList = cliUtil.getVerticalCliRet(cliRet)
    for cliRetDict in cliRetList:
        productModel = cliRetDict.get("Product Model", "")
        productVersion = cliRetDict.get("Product Version", "")

        if productModel == "" or productModel == "--" or productVersion == "" or productVersion == "--":  
            return cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "cannot.get.system.info")
    
    checkVersionList = config.CHECK_PRODUCT_VERSION.get(productModel, "")
    if len(checkVersionList) > 0:
        if productVersion in checkVersionList:
            return False, errMsg  
    return True, errMsg

        