# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
import decimal
from common import UnCheckException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ''


def execute(cli):
    """
        检查项名称：文件远程复制主从FS容量大小一致性检查
        检查方法：
            步骤1 以admin用户登陆设备
            步骤2 执行命令show remote_replication unified list_type=fs，查看当前阵列配置的所有文件远程复制pair，查询出“ID”字段值。
            步骤3 执行命令show remote_replication unified remote_replication_id=ID（使用步骤2中查询出来的ID），遍历查看当前阵列配置的所有的文件远程复制pair的详细信息，查询出“Primary Resource Capacity”和“Second Resource Capacity”。
        检查标准：
            1 如果步骤2查询结果没有文件系统远程复制pair，则检查通过。
            2 比较步骤3查询出来的每个pair的“Primary Resource Capacity”和“Second Resource Capacity”，如果“Primary Resource Capacity”大于“Second Resource Capacity”则不通过，其他情况通过。
    """
    global ALL_CLI_RET

    try:
        errMsg = ""
        # 检查版本号是否支持
        deviceInfo = common.getCurDeviceInfo(py_java_env)
        currentVersion = deviceInfo.getProductVersion()
        # 支持  V300R003C20SPC200之后的版本
        supportVersion = "V300R003C20SPC200"
        if currentVersion < supportVersion:
            return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ""

        # 获取所有文件远程复制pair的ID列表
        remoteReplicationIDList = getRemoteReplicationID(cli)
        if len(remoteReplicationIDList) == 0:
            return True, ALL_CLI_RET, ''
        
        stepProcess = 0
        currentProcess =0
        isDisplayProcess = False
        if len(remoteReplicationIDList) >=20:
            isDisplayProcess = True
            currentProcess = 5
            stepProcess = (1.0 / len(remoteReplicationIDList)) * (100 - currentProcess)
            
            
        riskPairPrimaryDict = {}
        riskPairsecondDict = {}
        noPairInfoList = []
        for remoteReplicationID in remoteReplicationIDList:

            if isDisplayProcess:
                currentProcess = common.refreshProcessByStep(currentProcess, stepProcess, py_java_env, LOGGER)
                
            primaryCapacity, secondCapacity = getResourceCapacity(cli, remoteReplicationID)
            if not primaryCapacity[0] or not secondCapacity[0]:
                noPairInfoList.append(remoteReplicationID)
                continue

            if primaryCapacity[1] > secondCapacity[1]:
                riskPairPrimaryDict[remoteReplicationID] = primaryCapacity[1]
                riskPairsecondDict[remoteReplicationID] = secondCapacity[1]
                LOGGER.logInfo("remoteReplicationID: %s, primaryCapacity:%s, secondCapacity:%s" % (remoteReplicationID, primaryCapacity[1], secondCapacity[1]))

        if len(riskPairPrimaryDict) == 0 and len(noPairInfoList) == 0:
            LOGGER.logInfo(" There is no risk fs")
            return True, ALL_CLI_RET, ''
        
        elif len(riskPairPrimaryDict) == 0 and len(noPairInfoList) != 0:
            errMsg += common.getMsg(LANG, "no.capacity.info", ",".join(noPairInfoList))
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg
        
        else:
            for riskPairID in riskPairPrimaryDict:
                # 提示信息：文件远程复制pair[ID:%s]的主端容量为%s GB,从端容量为%s GB.从端至少需要扩容%sGB.
                fsPrimaryCap = "%.3f" % riskPairPrimaryDict.get(riskPairID)
                fsSecondCap = "%.3f" % riskPairsecondDict.get(riskPairID)             
                errMsg += common.getMsg(LANG, "second.resource.capacity.is.lower",(riskPairID, fsPrimaryCap, fsSecondCap))
            return False, ALL_CLI_RET, errMsg

    except UnCheckException, unCheckException:
        LOGGER.logError(str(traceback.format_exc()))
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if not unCheckException.flag:
            return cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg
        return unCheckException.flag, unCheckException.cliRet, unCheckException.errorMsg

    except Exception, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal")
    finally:
        common.refreshProcess(py_java_env, 100, LOGGER)

def getRemoteReplicationID(cli):
    """
    @summary: 获取所有文件远程复制pair的ID列表

    @return:
        idList：所有文件远程复制pair的ID列表
    """

    global ALL_CLI_RET
    idList = []

    cmd = "show remote_replication unified list_type=fs"
    isSuccess, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)

    if not cliUtil.hasCliExecPrivilege(cliRet):
        raise UnCheckException(errMsg, ALL_CLI_RET, cliUtil.RESULT_NOSUPPORT)
    
    if isSuccess != True:
        errMsg = common.getMsg(LANG, "cannot.get.info.fs.pair")
        raise UnCheckException(errMsg, ALL_CLI_RET, isSuccess)

    if cliUtil.queryResultWithNoRecord(cliRet):
        return []

    linesList = cliUtil.getHorizontalCliRet(cliRet)

    for line in linesList:
        idNum = line.get("ID", "").strip()
        if idNum != "":
            idList.append(idNum)

    return idList


def getResourceCapacity(cli, remoteReplicationID):
    """
    @summary: 获取文件远程复制pair的主端和从端容量
        remoteReplicationID:   文件远程复制pair的ID
    @return:
        primaryCapacity：主端容量
        secondCapacity ：从端容量
    """
    global ALL_CLI_RET

    cmd = "show remote_replication unified remote_replication_id=%s" % remoteReplicationID
    isSuccess, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    
    if not cliUtil.hasCliExecPrivilege(cliRet):
        raise UnCheckException(errMsg, ALL_CLI_RET, cliUtil.RESULT_NOSUPPORT)
    if isSuccess != True:
        return (False, decimal.Decimal("0.0")), (False, decimal.Decimal("0.0"))

    pairDetilDictList = cliUtil.getVerticalCliRet(cliRet)
    LOGGER.logInfo("pairDetilList :%s" % pairDetilDictList)

    # 获取容量值
    if len(pairDetilDictList) == 0:
        return (False,decimal.Decimal("0.0")), (False,decimal.Decimal("0.0"))
    primaryCapacity = pairDetilDictList[0].get("Primary Resource Capacity", "").strip()
    secondCapacity = pairDetilDictList[0].get("Second Resource Capacity", "").strip()

    # 统一容量单位为GB
    primaryCapacityRes = common.changUnit2GBDecimal(primaryCapacity)
    secondCapacityRes = common.changUnit2GBDecimal(secondCapacity)

    return primaryCapacityRes, secondCapacityRes
