# --*-- coding: utf-8 --*--

import common
import cliUtil
import decimal

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    1、若步骤4获取的Page used（NFS或者CIFS任取其一）
            和步骤5计算出的页面资源使用数之差大于等于50000，则检查结果为不通过；
    '''
    failFlag = True
    cliRet = ""
    cliRetAll = ""
    errMsg = ""
    errMsgAll = ""
    thresholdValue = decimal.Decimal("50000")
    try:
        #检查当前版本是否涉及该检查项
        flag, product_version, cliRet, errMsg = cliUtil.getProductVersionWithCliRet(cli, LANG)
        cliRetAll += cliRet
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)
        
        if  product_version == "V500R007C00":
            return (cliUtil.RESULT_NOSUPPORT, cliRetAll, errMsg)
        
        #获取控制器ID列表
        flag, controlList, errMsg, cliRet = cliUtil.getControllerIdListWithRet(cli, LANG)
        cliRetAll += cliRet
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)
        
        #developer模式下查询CIFS服务和NFS服务的资源使用情况
        for contrId in controlList:
            #CIFS服务资源数
            cifscmd = "show cifs server_info controller=%s" % contrId
            checkFlag, cliRet, cifsPageResources, cifsPageUsed, errMsg = checkNasPagesValue(cli, cifscmd)
            cliRetAll += cliRet
            if checkFlag != True:
                flag = cliUtil.RESULT_NOCHECK
                if errMsg in errMsgAll:
                    continue
                errMsgAll += errMsg
                continue
            #NFS服务资源数
            nfscmd = "show nfs server_info controller=%s" % contrId
            checkFlag, cliRet, nfsPageResources, nfsPageUsed, errMsg = checkNasPagesValue(cli, nfscmd)
            cliRetAll += cliRet
            if checkFlag != True:
                flag = cliUtil.RESULT_NOCHECK
                if errMsg in errMsgAll:
                    continue
                errMsgAll += errMsg
                continue
            
            if cifsPageUsed != 0:
                pageUsed = cifsPageUsed
            else:
                pageUsed = nfsPageUsed
                
            #判断页面资源数使用是否超过阈值
            LOGGER.logInfo("cifsPageResources = %s" % cifsPageResources)
            LOGGER.logInfo("nfsPageResources = %s" % nfsPageResources)
            LOGGER.logInfo("pageUsed = %s" % pageUsed)
            rePageResource  = pageUsed - (cifsPageResources + nfsPageResources)
            LOGGER.logInfo("rePageResource = %s" % rePageResource)
            if rePageResource >= thresholdValue:
                failFlag = False
                errMsgAll += common.getMsg(LANG, "nas.pages.resource.overproof" , (contrId, rePageResource))
        
        if failFlag == False:
            flag = False
            
        return (flag, cliRetAll, errMsgAll)        
    except Exception, exception:
        LOGGER.logException(exception)
        errMsgAll += common.getMsg(LANG, "query.result.abnormal")
        return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsgAll)
          
def checkNasPagesValue(cli, cmd, developer = True):
    """
    @summary: 检查NAS资源页面数是否超过阈值
    @param cli: cli对象
    @param cmdList: cli命令列表
    @param equation: 阈值算法
    @param thresholdValue: 阈值
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 未超过阈值
            False: 超过阈值
        ret: 
            cli回文信息
        errMsg: 错误消息
    """
    flag = True
    pageResources = decimal.Decimal("0")
    pageUsed = decimal.Decimal("0")
    errMsg = ""
    cliRet = ""
    try:
        if developer:
            flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        else:
            flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        
        if flag != True:
            flag = cliUtil.RESULT_NOCHECK
            return (flag, cliRet, pageResources, pageUsed, errMsg)
        
        infoDict = cliUtil.getCliRetDict(cliRet)
        maxPayload = infoDict.get("Max Payload","0")
        requestTotal = infoDict.get("Request Total","0")    
        pageUsed = decimal.Decimal(infoDict.get("Page Used","0"))    
        pageResources = (decimal.Decimal(maxPayload)/decimal.Decimal("4096"))*decimal.Decimal(requestTotal)
        
        return (flag, cliRet, pageResources, pageUsed, errMsg)
    except Exception, exception:
        LOGGER.logException(exception)
        flag = cliUtil.RESULT_NOCHECK
        errMsg += common.getMsg(LANG, "query.result.abnormal")
        return (flag, cliRet, pageResources, pageUsed, errMsg)
