# -*- coding: UTF-8 -*-
import traceback

import cliUtil
import common
from cbb.frame.util.common import fakeProgress
from common_utils import get_err_msg

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env


@fakeProgress(py_java_env, totalSeconds=120, logger=LOGGER, interval=1)
def execute(cli):
    """
    检查绑定口的MTU是否修改
    :param cli:
    :return:
    """
    net_check_bond_mtu = NetCheckBondMtu(
        cli, LANG, PY_JAVA_ENV, LOGGER
    )
    flag, msg = net_check_bond_mtu.execute_check()
    return flag, "\n".join(net_check_bond_mtu.all_ret_list), msg


class NetCheckBondMtu:
    def __init__(self, cli, lang, env, logger):
        self.cli = cli
        self.lang = lang
        self.env = env
        self.logger = logger
        self.all_ret_list = []
        self.err_msg = ""

    def execute_check(self):
        try:
            flag, product_version, cli_ret, err_msg = \
                cliUtil.getProductVersionWithCliRet(self.cli, LANG)
            self.all_ret_list.append(cli_ret)
            if flag is not True:
                return cliUtil.RESULT_NOCHECK, err_msg
            blank_version_list = ['6.0.RC1', '6.0.0', '6.0.0.SPH1',
                                  '6.0.0.SPH2', '6.0.0.SPH3', '6.0.0.SPH4',
                                  '6.0.0.SPH5',
                                  '6.0.0.SPH6', '6.0.0.SPH7', '6.0.0.SPH8',
                                  '6.0.1', '6.0.1.SPH1', '6.0.1.SPH2',
                                  '6.1.RC1']
            if product_version not in blank_version_list:
                return True, ''

            err_msg_id_list = self.check_bond_mtu()
            if not err_msg_id_list:
                return True, ''
            return False, get_err_msg(LANG,
                                      "software.net.check.bond.mtu.not.pass",
                                      (product_version,
                                       ','.join(err_msg_id_list)))
        except common.UnCheckException as e:
            LOGGER.logError(str(e))
            return cliUtil.RESULT_NOCHECK, e.errorMsg
        except Exception:
            LOGGER.logError(str(traceback.format_exc()))
            return (
                cliUtil.RESULT_NOCHECK,
                common.getMsg(self.lang, "query.result.abnormal"),
            )

    def check_bond_mtu(self):
        """
        判断绑定端口值是否被修改
        :return: 错误的端口ID list
        """
        err_id_list = list()
        cmd = "show bond_port"
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(self.cli, cmd,
                                                            True, self.lang)
        self.all_ret_list.append(cli_ret)
        if flag is not True:
            raise common.UnCheckException(err_msg, cli_ret)

        if cliUtil.queryResultWithNoRecord(cli_ret):
            return err_id_list

        bond_port_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
        for bond in bond_port_list:
            running_status = bond.get("Running Status", "")
            mtu = bond.get("MTU", "")
            if running_status.strip() == 'Link Up' and '1500' != mtu.strip():
                err_id_list.append(bond.get("ID", ""))
        return err_id_list
