# -*- coding: UTF-8 -*-
import traceback

import cliUtil
import common
from common import UnCheckException
from common_utils import get_err_msg
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env


def execute(cli):
    """
    重构任务开关状态检查
    :param cli:
    :return:
    """
    recon_check = ReconSwitchIsOff(cli, LANG, PY_JAVA_ENV, LOGGER)
    flag, msg = recon_check.execute_check()
    return flag, "\n".join(recon_check.all_ret_list), msg


class ReconSwitchIsOff:
    def __init__(self, cli, lang, env, logger):
        self.cli = cli
        self.lang = lang
        self.env = env
        self.logger = logger
        self.all_ret_list = list()

    def execute_check(self):
        try:
            domain_id_list = self.get_domain_info()
            if not domain_id_list:
                return True, ""
            self.change_to_developer()
            err_domain_list = self.check_domain_recon(domain_id_list)
            if not err_domain_list:
                return True, ""
            return False, get_err_msg(
                self.lang,
                "software.domain.recon.switch.off",
                ','.join(err_domain_list)
            )

        except UnCheckException as e:
            return cliUtil.RESULT_NOCHECK, e.errorMsg
        except Exception:
            LOGGER.logError(str(traceback.format_exc()))
            return (
                cliUtil.RESULT_NOCHECK,
                common.getMsg(self.lang, "query.result.abnormal"),
            )

    def change_to_developer(self):
        """
        切换到developer模式，获取回显
        :return:
        """
        flag, cli_ret, err_msg = cliUtil.enterDeveloperMode(
            self.cli, self.lang
        )
        self.all_ret_list.append(cli_ret)
        if flag is not True:
            raise UnCheckException(err_msg, cli_ret)

    def get_domain_info(self):
        """
        获取domain id信息
        :return: domain_id_list
        """

        domain_id_list = list()
        cmd = "show disk_domain general"
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(self.cli, cmd,
                                                            True, self.lang)
        self.all_ret_list.append(cli_ret)
        if flag is not True:
            raise UnCheckException(err_msg, cli_ret)

        domain_list = cliUtil.getHorizontalCliRet(cli_ret)
        for domain_info in domain_list:
            domain_id = domain_info.get("ID", "")
            domain_id_list.append(domain_id)

        return domain_id_list

    def check_domain_recon(self, domain_id_list):
        """
        查看domain重构开关
        :param domain_id_list: 硬盘域列表
        :return:
        """
        err_domain_list = list()
        for domain_id in domain_id_list:
            cmd = "show disk_domain bgr_task_switch disk_domain_id={} " \
                  "task_type=recon"
            flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(self.cli,
                                                                cmd.format(
                                                                    domain_id),
                                                                True,
                                                                self.lang)
            self.all_ret_list.append(cli_ret)
            if flag is not True:
                raise UnCheckException(err_msg, cli_ret)

            if "Switch Status : off" in cli_ret:
                err_domain_list.append(domain_id)

        return err_domain_list
