# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    Tier状态检查: 
        1 如果POOL不存在表示正常；
        2 Health Status为Normal且Running Status为Online表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show storage_pool general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.pool.info")
            LOGGER.logNoPass("Cannot get information about POOL")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0

        for line in cliRetLinesList:
            poolId = line.get("ID")
            cmd_tier = "show storage_pool tier pool_id=%s" % poolId
            LOGGER.logExecCmd(cmd_tier)
            checkRetTier = cliUtil.excuteCmdInCliMode(cli, cmd_tier, True, LANG, cliUtil.endWithSignToAdmin)
            cliRet += checkRetTier[1]
            if checkRetTier[0] != True: 
                errMsg += checkRetTier[2]
                LOGGER.logSysAbnormal()
                return (checkRetTier[0], cliRet, errMsg)
            
            cliRetTier = checkRetTier[1]
            tierList = cliUtil.getVerticalCliRet(cliRetTier)
            if len(tierList) == 0:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.pool.tier.info",poolId)
                LOGGER.logNoPass("Cannot get information about Tier")
            
            for retDict in tierList:
                tierName = retDict.get("Name")
                healthStatus = retDict.get("Health Status")
                runningStatus = retDict.get("Running Status")
                
                if healthStatus != common.STATUS_NORMAL:
                    flag = False
                    if cliUtil.isChinese(LANG):
                        errMsg += u"\nPOOL[%s]名称为%s的Tier健康状态异常(健康状态：%s)" % (poolId, tierName, healthStatus)
                    else:
                        errMsg += "\nThe Health Status of tier named %s in POOL [%s] is abnormal (Health Status:%s)" % \
                            (tierName, poolId, healthStatus)
                    LOGGER.logNoPass("The Health Status of tier named %s in POOL [%s] is abnormal (Health Status:%s)" % 
                            (tierName, poolId, healthStatus))
                    
                if runningStatus not in [common.STATUS_ONLINE, common.STATUS_BALANCING]:
                    flag = False
                    if cliUtil.isChinese(LANG):
                        errMsg += u"\nPOOL[%s]名称为%s的Tier运行状态异常(运行状态：%s)" % (poolId, tierName, runningStatus)
                    else:
                        errMsg += "\nThe Running Status of tier named %s in POOL [%s] is abnormal (Running Status:%s)" % \
                            (tierName, poolId, runningStatus)
                    LOGGER.logNoPass("The Running Status of tier named %s in POOL [%s] is abnormal (Running Status:%s)" % 
                            (tierName, poolId, runningStatus))
                
        if flag:
            LOGGER.logPass()
               
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
