
# -*- coding: UTF-8 -*-
import cliUtil
import common
import re

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    Tier容量检查: 
        1） 当Storage Pool不存在时，则检查通过；
        2) 当所有的Storage Pool中的tier的容量小于等于45T(18000V1为60T)时，则检查结果为通过；
        3） 当Storage Pool中的某个tier的容量超过45T(18000V1为60T)且小于等于100T时，则检查结果为警告；
        4） 当Storage Pool中的某个tier的容量超过100T时，则检查结果为不通过；
        5） 其他情况检查不通过；
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    warnFlag = False
    failFlag = False
    #配置涉及该检查项的的产品软件版本和补丁版本
    riskSoftwareVersionList = ['V300R001C20SPC200','V100R001C30SPC200','V200R002C30SPC200']
    riskSoftwareVersionV3R3 = 'V300R003C10SPC100'
    ModelList18000V1 = ['HVS85T','HVS88T','18500','18800','18800F']
    repairPatchVersionDict = {
                            "V300R001C20SPC200":"V300R001C20SPH202",
                            "V100R001C30SPC200":"V100R001C30SPH202",
                            "V200R002C30SPC200":"V200R002C30SPH202",
}
    warnCapacity = 45.0
    failCapacity = 100.0
    try:
        storageTypeRet = cliUtil.getProductModel(cli, LANG)
        if storageTypeRet[0] != True:
            if not storageTypeRet[0]:
                return cliUtil.RESULT_NOCHECK, storageTypeRet[1], storageTypeRet[2]  # 修改备注：getProductModel返回False是未检查
            return storageTypeRet
        productType = storageTypeRet[1]
        if productType in ModelList18000V1:
            warnCapacity = 60.0
        #获取软件版本号和补丁版本号，并判断是否为风险版本
        checkRet, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
        cliRet += '\n' + checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (cliUtil.RESULT_NOCHECK, cliRet , checkRet[2])

        result, currentVersion, errInfo = common.getCurrentVersion(currentVersionDictList, LANG)
        if not result:
            errMsg += errInfo
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：getCurrentVersion返回False是未检查

        result, hotPatchVersion, errInfo = common.getHotPatchVersion(hotPatchVersionDictList, LANG)
        # 修改备注：通过hotPatch信息字典列表获取补丁信息（getHotPatchVersion）失败，返回False，但是获取失败和补丁信息不一致未做区分
        if not result:
            errMsg += errInfo
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        
        if currentVersion in riskSoftwareVersionList and hotPatchVersion != "--" and hotPatchVersion >= repairPatchVersionDict.get(currentVersion):
            return (True, cliRet, errMsg)
        if currentVersion >= riskSoftwareVersionV3R3:
            return (True, cliRet, errMsg)
        if not re.match('V300R003.*', currentVersion) and currentVersion not in riskSoftwareVersionList:
            return (cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        cmd = "show storage_pool general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        cliRet += checkRet[1]
        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.pool.info")
            LOGGER.logNoPass("Cannot get information about POOL")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0

        for line in cliRetLinesList:
            poolId = line.get("ID")
            cmd_tier = "show storage_pool tier pool_id=%s" % poolId
            LOGGER.logExecCmd(cmd_tier)
            checkRetTier = cliUtil.excuteCmdInCliMode(cli, cmd_tier, True, LANG, cliUtil.endWithSignToAdmin)
            cliRet += checkRetTier[1]
            if checkRetTier[0] != True: 
                errMsg += checkRetTier[2]
                LOGGER.logSysAbnormal()
                return (checkRetTier[0], cliRet, errMsg)
            
            cliRetTier = checkRetTier[1]
            tierList = cliUtil.getVerticalCliRet(cliRetTier)
            if len(tierList) == 0:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.tier.info")
                LOGGER.logNoPass("Cannot get information about Tier")
            
            for retDict in tierList:
                tierName = retDict.get("Name")
                capacity = retDict.get("Capacity")
                num = cliUtil.transferCapToTB(capacity)
                if warnCapacity < num <= failCapacity:
                    warnFlag = True
                    errMsg += common.getMsg(LANG, "tier.capacity.info",(poolId, tierName, capacity))
                    LOGGER.logNoPass("The capacity of tier named %s in POOL [%s] is abnormal (capacity:%s)" % 
                            (tierName, poolId, capacity))
                elif num > failCapacity:
                    failFlag = True
                    errMsg += common.getMsg(LANG, "tier.capacity.info",(poolId, tierName, capacity))
                    LOGGER.logNoPass("The capacity of tier named %s in POOL [%s] is abnormal (capacity:%s)" % 
                            (tierName, poolId, capacity))

        if warnFlag:
            flag = cliUtil.RESULT_WARNING

        #若容量检查既有警告又有不通过，则最终结果为不通过
        if failFlag:
            flag = False

        if flag == True:
            LOGGER.logPass()
               
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

